package unlh.graph.algo;

import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;

public class Dijkstra {
    Graph graph; // notre graphe
    Node source; // le noeud source
    HashMap<Node, Double> queue; // notre fil prioritaire
    /**
     * Constructeur
     * @param graph
     * @param source
     */
    public Dijkstra(Graph graph, Node source) {
        this.graph = graph;
        this.source = source;
        queue = new HashMap<Node, Double>();
    }

    /**
     * Phase d'initialisation de l'algorithme
     * Les distances des noeuds seront mis à Double.POSITIVE_INFINITY
     */
    private void init() {
        for (Node n : graph.getEachNode()) {
            n.addAttribute("dist", n.getId().equals(source.getId()) ? 0 : Double.POSITIVE_INFINITY);
            n.addAttribute("parent", new Stack<Node>());
        }
    }
    /**
     * Calcul le plus court chemin
     */
    public void compute() {
        init();
        queue.put(source, source.getAttribute("dist"));
        while (queue.size() != 0) {
            Node currNode = getLowestDistanceNode(queue.keySet());
            Iterator<Edge> edgeIterator = currNode.getLeavingEdgeIterator();
            queue.remove(currNode);
            System.out.println("" + currNode.getId() + " " + currNode.getAttribute("dist"));
            // parcours des noeuds voisins
            while (edgeIterator.hasNext()) {
                Edge currEdge = edgeIterator.next();
                Node opNode = currEdge.getTargetNode();
                if(! queue.containsKey(opNode)) {
                    Double currNodeDist = currNode.getAttribute("dist");
                    Double edgeWeight = currEdge.getAttribute("cap");
                    Double sum = currNodeDist + edgeWeight;
                    Double opNodeDistance = opNode.getAttribute("dist");
                    if (opNodeDistance > sum) {
                        opNode.setAttribute("dist", sum);
                        // reste plus
                        opNode.setAttribute("parent", currNode);
                        queue.put(opNode, opNode.getAttribute("dist"));
                    }
                }
                System.out.println("  " + opNode.getId() + " " + opNode.getAttribute("dist"));
            }
        }
    }

    public boolean isQueueEmpty() {
        return queue.isEmpty();
    }

    /**
     * Extrait le noeud avec la priorité minimum depuis notre file de priorité
     * @return Node
     */
    private Node getLowestDistanceNode(Set<Node> nodes) {
        Node lowestDistanceNode = null;
        Double lowestDistance = Double.MAX_VALUE;
        for (Node node : nodes) {
            Double nodeDistance = node.getAttribute("dist");
            if (nodeDistance < lowestDistance) {
                lowestDistance = nodeDistance;
                lowestDistanceNode = node;
            }
        }
        return lowestDistanceNode;
    }

    /**
     * Getters de l'attribut graph
     *
     * @return
     */
    public Graph getGraph() {
        return graph;
    }

    /**
     * Setter de l'attribut graph
     * @param graph
     */
    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    /**
     * Getters de l'attribut source
     *
     * @return
     */
    public Node getSource() {
        return source;
    }

    /**
     * setters de l'attribut source
     * @param source
     */
    public void setSource(Node source) {
        this.source = source;
    }
}
