import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;
import org.graphstream.graph.implementations.SingleGraph;
import org.graphstream.algorithm.generator.RandomGenerator;

public class GraphGenerator {
    public static void main(String argvs[]) {
        Graph graph = new SingleGraph("Random");
        RandomGenerator gen = new RandomGenerator(2);
        gen.setEdgeAttributesRange(10.0, 50.0);
        gen.addEdgeAttribute("weight");
        gen.addSink(graph);
        gen.begin();
        for (int i = 0; i < 10; i++)
            gen.nextEvents();
        gen.end();

        for (Edge e : graph.getEachEdge()) {
            Double rounded = Double.valueOf(Math.round(Double.parseDouble(e.getAttribute("weight").toString())));
            e.addAttribute("ui.style", "shape:circle;fill-color: black;size: 1px; text-alignment: center;");
            e.setAttribute("ui.label", rounded.toString());
        }

        graph.display();
    }
}
