package fr.univlehavre.entree;

import fr.univlehavre.carnet.Carnet;
import org.junit.jupiter.api.Test;

import java.util.Arrays;

import static org.junit.jupiter.api.Assertions.*;

class SelectionTest {

	@Test
	void recherche() {
		Personne personne = new Personne("Potter",new String[]{"Prince", "Edouard"}, Genre.HOMME, null, new Societe("Ecole de sorcellerie Poudlard"), "Elève");
		Societe societe = new Societe("Henri Fraise & Fils");
		Carnet carnet = new Carnet();
		carnet.lectureFichier("carnet.csv");
		carnet.ajoutEntree(personne);

		assertTrue(personne.recherche("Potter"));
		assertTrue(societe.recherche("Fils"));
		assertTrue(Arrays.asList(carnet.getEntrees()).contains(personne),"Personne not in entrees");
	}
}
