package fr.univlehavre.entree;

import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.*;

class PersonneTest {

	@Test
	void testToString() {
		Personne p = new Personne("Potter",new String[]{"Prince", "Edouard"}, Genre.HOMME, null, new Societe("Ecole de sorcellerie Poudlard"), "Elève");

		String abregee1 = p.toString(Presentation.ABREGE, Sens.NOM_PRENOMS);
		String abregee2 = p.toString(Presentation.ABREGE, Sens.PRENOMS_NOM);
		String simple = p.toString(Presentation.SIMPLE, Sens.NOM_PRENOMS);
		String complete = p.toString(Presentation.COMPLET, Sens.NOM_PRENOMS);

		assertEquals(abregee1.trim(), "Potter P. E. ".trim(), "Test for Abregee NOM_PRENOMS does not pass"); // trim() pour s'assurer des espaces
		assertEquals(abregee2.trim(), "P. E. Potter".trim(), "Test for Abregee PRENOMS_NOM does not pass"); // trim() pour s'assurer des espaces
		assertEquals(simple, "M. Prince E. Potter (Ecole de sorcellerie Poudlard)", "Test for Simple NOM_PRENOMS does not pass");
		assertEquals(complete, "M. Prince Edouard Potter\n-Société: Ecole de sorcellerie Poudlard\n-Fonction: Elève", "Test complete NOM_PRENOMS");
	}
}
