package fr.univlehavre.carnet;

import fr.univlehavre.entree.Entree;
import fr.univlehavre.entree.Genre;
import fr.univlehavre.entree.Personne;
import fr.univlehavre.entree.Societe;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.provider.CsvFileSource;
import org.junit.jupiter.params.provider.CsvSource;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.junit.jupiter.params.ParameterizedTest;

import static org.junit.jupiter.api.Assertions.*;

class LectureTest {
	@Test
	void lectureFichier() {
		Carnet carnet = new Carnet();
		carnet.lectureFichier("carnet.csv");
		Entree[] entrees = carnet.getEntrees();
		/**
		 * Verification de l'entite 0 et 1
		 */
		String[] actualprenoms = ((Personne)entrees[1]).getPrenoms();
		String[] expectedPrenoms = new String[]{ "Albus","Perceval","Wulfric","Brian" };
		assertEquals(entrees.length, 4, "Entree length should be 4");
		assertEquals(((Societe)entrees[0]).getRaisonSociale(), "Ecole de sorcellerie Poudlard", "Raison social should match");
		assertEquals(((Personne)entrees[1]).getNom(), "Dumbledore","Entree[1] nom does not match");
		for (int i = 0; i < actualprenoms.length; i++) {
			assertEquals(actualprenoms[i], expectedPrenoms[i],"Entree[1] prenoms[" + i + "] does not match");
		}
		assertEquals(((Personne)entrees[1]).getGenre(), Genre.HOMME, "Entree[1] Genre does not match");
	}
}
