package fr.univlehavre.entree;

import java.util.Arrays;

public class Personne implements Entree {
	private String nom;
	private String[] prenoms;
	private Genre genre;
	private Personne conjoint;
	private Societe societe;
	private String fonction;

	public Personne(String nom, String[] prenoms, Genre genre, Personne conjoint, Societe societe, String fonction) {
		this.nom = nom;
		this.prenoms = prenoms;
		this.genre = genre;
		this.conjoint = conjoint;
		this.societe = societe;
		this.fonction = fonction;
	}

	public String getNom() {
		return nom;
	}

	public String[] getPrenoms() {
		return prenoms;
	}

	public Genre getGenre() {
		return genre;
	}

	public Personne getConjoint() {
		return conjoint;
	}

	public Societe getSociete() {
		return societe;
	}

	public String getFonction() {
		return fonction;
	}

	@Override
	public String toString(Presentation presentation, Sens sens) {
		String result = "";
		switch (presentation) {
			case COMPLET:
				result = String.format(this.formatGenre() + " " + formatPrenoms() + this.nom+ "\n" + "-Société: " + this.societe.getRaisonSociale() + "\n" + "-Fonction: " + this.fonction);
				break;
			case ABREGE:
				result = sens == Sens.NOM_PRENOMS ? this.nom + " " + initiales() : initiales() + this.nom;
				break;
			case SIMPLE:
				result = this.formatGenre() + " " + initialesSimple() + this.nom +" (" + this.societe.getRaisonSociale() + ")";
				break;
		}
		return result;
	}

	@Override
	public Boolean recherche(String text) {
		return this.nom.contains(text) || Arrays.asList(this.prenoms).contains(text);
	}

	private String initialesSimple() {
		String result = this.prenoms[0] + " ";
		int len = this.prenoms.length;
		String[] prenoms = Arrays.copyOfRange(this.prenoms, 1, len);
		for (String prenom : prenoms) {
			result += prenom.charAt(0) + ". ";
		}
		return result;
	}

	private String initiales() {
		String result = "";
		for (String prenom : this.prenoms) {
			result += prenom.charAt(0) + ". ";
		}
		return result;
	}

	private String formatPrenoms() {
		String result = "";
		for (String prenom : this.prenoms) {
			result += prenom + " ";
		}
		return result;
	}

	private String formatGenre() {
		String genre ="";
		switch (this.genre) {
			case HOMME:
				genre = "M.";
				break;
			case FEMME:
				genre = "Mme";
				break;
		}
		return genre;
	}
}
