package fr.univlehavre.carnet;

import fr.univlehavre.entree.Entree;
import fr.univlehavre.entree.Genre;
import fr.univlehavre.entree.Personne;
import fr.univlehavre.entree.Societe;

import java.io.*;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Carnet {
	private Entree[] entrees;
	private Entree[] selectionnees;

	public Entree[] getEntrees() {
		return entrees;
	}

	public Entree[] getSelectionnees() {
		return selectionnees;
	}

	public void lectureFichier(String fichier) {
		BufferedReader br = null;
		String csvline = "";
		String csvSplitBy = ";";
		List<Entree> entrees = new ArrayList<Entree>();
		try {
			ClassLoader classLoader = getClass().getClassLoader();
			File file = new File(classLoader.getResource(fichier).getFile());
			br = new BufferedReader(new FileReader(file));
			while((csvline =br.readLine()) != null) {
				String[] line = csvline.split(csvSplitBy);
				if(line[1].equals("SOCIETE")) {
					Societe societe = new Societe(line[2]);
					entrees.add(societe);
				} else {
					if(line[1].equals("PERSONNE")) {
						String[] prenoms = line[2].split(",");
						Genre genre = line[4].equals("H") ? Genre.HOMME : Genre.FEMME;
						entrees.add(new Personne(line[3], prenoms,genre, null, null, line[7]));
					}
				}
			}
			this.entrees = entrees.toArray(new Entree[entrees.size()]);
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			if(br != null) {
				try {
					br.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
	}

	public void ajoutEntree(Entree entree) {
		List<Entree> entrees = new ArrayList<Entree>(Arrays.asList(this.entrees));
		entrees.add(entree);
		this.entrees = entrees.toArray(new Entree[entrees.size()]);
	}

	public void selection(String selection) {
		Entree[] selections = new Entree[1];
		Entree[] entrees = this.entrees;
		for (int i = 0; i < entrees.length; i++) {
			Entree e = this.entrees[i];
			if(e.recherche(selection)){
				selections[0] = e;
				this.selectionnees = selections;
			}
		}
	}

	public void selection(Entree entree) {
		Entree[] entrees = this.entrees;
		for (int i = 0; i < entrees.length; i++) {
			if(entrees[i].equals(entree))
				this.selectionnees = new Entree[]{entree};
		}
	}

	public void selection(Entree[] entrees) {
		this.selectionnees = entrees;
	}

	public void deselection() {
		this.selectionnees = new Entree[1];
	}

	public Entree[] recherche(String recherche) {
		List<Entree> entrees = new ArrayList<Entree>();
		for (Entree e:this.entrees) {
			if(e.recherche(recherche))
				entrees.add(e);
		}
		return entrees.toArray(new Entree[entrees.size()]);
	}
}
