# Bibliothèque Rust pour architecture avancée

bibliothèque de fonctions utilitaires pour la programmation RUST en Licence 3 Informatique : architecture avancée
- Compatibilité: Rust 1.90.0+, OS [macOS/Linux/Windows], arch [x86_64/aarch64]


## Installation

Ajoutez ceci dans votre `Cargo.toml` :

```toml
[dependencies]

archi_avancee = { git = "https://www-apps.univ-lehavre.fr/forge/amantonl/archi_avancee.git" }
```

## Utilisation

```rust
use archi_avancee::duree::*;
use archi_avancee::simd::*;

```


### Fonctionnalités principales

- Mesure de durée d’exécution d’une procédure
- Mesure de durée et récupération du résultat d’une fonction
- Lecture du compteur de cycles CPU (RDTSC/équivalent) selon l’architecture
- Comptage de cycles consommés par un bloc
- Détection des extensions SIMD x86 (SSE/AVX)

### Utilisation rapide

- Mesurer la durée d’un bloc:
```rust
use archi_avancee::duree::duree_procedure;

let d = duree_procedure(|| {
    // code à mesurer
});
println!("Durée: {:?}", d);
```


- Mesurer durée + résultat:
```rust
use archi_avancee::duree::duree_fonction;

let (res, d) = duree_fonction(|| votre_fonction_de_calcul);
println!("Résultat: {res}, Durée: {d:?}");
```


- Nombre de cycles CPU consommés:
```rust
use archi_avancee::duree::nombre_cycles;

let cycles = nombre_cycles(|| {
    // code à profiler finement
});
println!("Cycles: {cycles}");
```


- Détection SIMD (x86/x86_64 uniquement):
```rust
use archi_avancee::simd::test_sse_avx;

test_sse_avx(); // Affiche les features disponibles
```


### Plateformes et garde-fous

- x86/x86_64: support RDTSC et détection SSE/AVX.
- aarch64: lecture du compteur système (cntvct_el0).
- Autres architectures: panique sur la fonction RDTSC; documentez-le pour éviter l’appel sur plateformes non supportées. En cas de besoin, encapsulez derrière #[cfg] ou un feature flag.

Exemple de protection:
```rust
#[cfg(any(target_arch = "x86", target_arch = "x86_64", target_arch = "aarch64"))]
{ /* appel sûr */ }
```


## Licence

MIT OR Apache-2.0
 
