# Configuration de la sortie
set terminal pngcairo size 1000,700 enhanced font 'Verdana,10'
set output 'comparaison_globale_tp.png'

# Titre et légende
set title "Comparaison complète de la propagation SIS (3 réseaux et 3 scénarios )"
set xlabel "Temps t (jour)"
set ylabel "Fraction infectée"
set grid
set key outside right top vertical
set yrange [0:0.9]
set xrange [0:90]

# --- DÉFINITION DES STYLES ---
# DBLP (Vert)
set style line 1 lc rgb '#4daf4a' lt 1 lw 2   # aucun
set style line 2 lc rgb '#4daf4a' dt 2 lw 2   # immunisation aléatoire
set style line 3 lc rgb '#4daf4a' dt 3 lw 2   # immunisation sélective

# ER (Orange/Marron)
set style line 4 lc rgb '#d95f02' lt 1 lw 2   # aucun
set style line 5 lc rgb '#d95f02' dt 2 lw 2   # immunisation aléatoire
set style line 6 lc rgb '#d95f02' dt 3 lw 2   # immunisation sélective

# BA (Violet/Bleu)
set style line 7 lc rgb '#7570b3' lt 1 lw 2   # aucun
set style line 8 lc rgb '#7570b3' dt 2 lw 2   # immunisation aléatoire
set style line 9 lc rgb '#7570b3' dt 3 lw 2   # immunisation sélective

# --- TRACÉ DES COURBES ---
# Colonnes : 1:t | 2:DBLP_none 3:DBLP_rand 4:DBLP_sel | 5:ER_none 6:ER_rand 7:ER_sel | 8:BA_none 9:BA_rand 10:BA_sel

plot "virus_compare.dat" using 1:2 with lines ls 1 title "DBLP - aucun", \
     "virus_compare.dat" using 1:3 with lines ls 2 title "DBLP - immunisation aléatoire", \
     "virus_compare.dat" using 1:4 with lines ls 3 title "DBLP - immunisation sélective", \
     "virus_compare.dat" using 1:5 with lines ls 4 title "ER - aucun", \
     "virus_compare.dat" using 1:6 with lines ls 5 title "ER - immunisation aléatoire", \
     "virus_compare.dat" using 1:7 with lines ls 6 title "ER - immunisation sélective", \
     "virus_compare.dat" using 1:8 with lines ls 7 title "BA - aucun", \
     "virus_compare.dat" using 1:9 with lines ls 8 title "BA - immunisation aléatoire", \
     "virus_compare.dat" using 1:10 with lines ls 9 title "BA - immunisation sélective"
