# Configuration de la sortie
set terminal pngcairo size 1200,600 enhanced font 'Verdana,10'
set output 'comparaison_reseaux_theoriques.png'

# Configuration du multiplot (2 graphiques côte à côte)
set multiplot layout 1,2 title "Comparaison de la propagation : Aléatoire (ER) vs Attachement Préférentiel (BA)"

# --- PREMIER GRAPHIQUE : ERDOS-RENYI ---
set title "Réseau Aléatoire (ER)"
set xlabel "Jours"
set ylabel "Fraction d'infectés"
set grid
set yrange [0:0.8]
set key top right

plot "simu_er.dat" using 1:2 with lines lw 2 lc rgb '#e41a1c' title "Témoin", \
     "simu_er.dat" using 1:3 with lines lw 2 lc rgb '#377eb8' title "Aléatoire", \
     "simu_er.dat" using 1:4 with lines lw 2 lc rgb '#4daf4a' title "Sélective"

# --- DEUXIÈME GRAPHIQUE : BARABASI-ALBERT ---
set title "Réseau Préférentiel (BA)"
set xlabel "Jours"
set ylabel "Fraction d'infectés"
set grid
set yrange [0:0.8]
set key top right

plot "simu_ba.dat" using 1:2 with lines lw 2 lc rgb '#e41a1c' title "Témoin", \
     "simu_ba.dat" using 1:3 with lines lw 2 lc rgb '#377eb8' title "Aléatoire", \
     "simu_ba.dat" using 1:4 with lines lw 2 lc rgb '#4daf4a' title "Sélective"

unset multiplot
