package tpri;

import java.io.IOException;

import org.graphstream.algorithm.Toolkit;
import org.graphstream.algorithm.generator.BarabasiAlbertGenerator;
import org.graphstream.algorithm.generator.RandomGenerator;
import org.graphstream.graph.Graph;
import org.graphstream.graph.implementations.SingleGraph;
import org.graphstream.stream.file.FileSourceEdge;

public class ErdosEtBarbasi {

	public static void main(String[] args) throws IOException{
		// TODO Auto-generated method stub
		
		System.setProperty("org.graphstream.ui", "swing"); // utile si tu visualises

        String filename = "com-dblp.ungraph.txt";

        Graph graph = new SingleGraph("DBLP");
        FileSourceEdge fs = new FileSourceEdge();

        fs.addSink(graph);

        try {
            fs.readAll(filename);  // <-- méthode FileSourceEdge
        } finally {
            fs.removeSink(graph);
        }
        
        double avgDegree = Toolkit.averageDegree(graph);
		
		
		int n = 317080; // Nombre de nœuds
		// Récupérer le degré moyen DBLP
		double kER = avgDegree; // RandomGenerator crée k arêtes par nouveau nœud

		int mBA = (int) avgDegree / 2 ;    // Arêtes par nouveau nœud pour BA
		
        // ==== Réseau aléatoire ER ====
        System.out.println("\n=== Réseau Aléatoire ER ===");
        Graph erGraph = new SingleGraph("Random");
        RandomGenerator erGen = new RandomGenerator(kER);
        erGen.addSink(erGraph);
        erGen.begin();
        for(int i = 0; i < n; i++) erGen.nextEvents();
        erGen.end();
        // erGraph.display(); // visualisation optionnelle
        measureGraph(erGraph, "ER");
        
        // ==== Réseau Barabasi-Albert ====
        System.out.println("\n=== Réseau Barabasi-Albert ===");
        Graph baGraph = new SingleGraph("Barabasi-Albert");
        BarabasiAlbertGenerator baGen = new BarabasiAlbertGenerator(mBA);
        baGen.addSink(baGraph);
        baGen.begin();
        for(int i = 0; i < n; i++) baGen.nextEvents();
        baGen.end();
        // baGraph.display(); // visualisation optionnelle
        measureGraph(baGraph, "BA");
		
	}
	
    // Mesure des caractéristiques
    public static void measureGraph(Graph g, String name) throws IOException {
        int n = g.getNodeCount();
        int m = g.getEdgeCount();
        double avgDegree = Toolkit.averageDegree(g);
        double clustering = Toolkit.averageClusteringCoefficient(g);
        double p = avgDegree / (n - 1);
        double clusteringRandom = p;

        System.out.println("Nombre de nœuds : " + n);
        System.out.println("Nombre d'arêtes : " + m);
        System.out.printf("Degré moyen : %.6f%n", avgDegree);
        System.out.printf("Clustering coefficient : %.6f%n", clustering);
        System.out.printf("Clustering réseau aléatoire (même n et degré moyen) : %.10f%n", clusteringRandom);



    }

}
