package tpri;


import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.implementations.DefaultGraph;
import org.graphstream.stream.file.FileSourceEdge;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

/**
 * Calcul du degré moyen des groupes d'immunisation pour justifier 
 * l'efficacité du paradoxe de l'amitié.
 */
public class DegreeMoyen {
    
    public static void main(String[] args) {
        String cheminFichier = "com-dblp.ungraph.txt";
        Graph reseau = new DefaultGraph("GrapheDBLP");
        FileSourceEdge source = new FileSourceEdge();
        source.addSink(reseau);
        
        try { 
            source.readAll(cheminFichier); 
        } catch (IOException e) { 
            System.err.println("Erreur de chargement."); 
            return; 
        }

        System.out.println("=== ANALYSE DE L'EFFICACITÉ DE L'IMMUNISATION ===");
        
        // --- Paramètres de l'échantillonnage ---
        int tailleEchantillon = 10000; 
        List<Node> tousLesNoeuds = new ArrayList<>();
        reseau.nodes().forEach(tousLesNoeuds::add);
        Collections.shuffle(tousLesNoeuds);
        
        double sommeDegresGroupe0 = 0; // Personnes choisies au hasard
        double sommeDegresGroupe1 = 0; // Leurs amis choisis au hasard
        int nbAmisSelectionnes = 0;
        Random generateur = new Random();

        for(int i = 0; i < Math.min(tailleEchantillon, tousLesNoeuds.size()); i++) {
            Node individuA = tousLesNoeuds.get(i);
            
            // On calcule le degré du Groupe 0
            sommeDegresGroupe0 += individuA.getDegree();
            
            // Sélection d'un ami (Groupe 1)
            List<Node> relations = new ArrayList<>();
            individuA.neighborNodes().forEach(relations::add);
            
            if(!relations.isEmpty()) {
                // On choisit un voisin au hasard
                Node individuB = relations.get(generateur.nextInt(relations.size()));
                sommeDegresGroupe1 += individuB.getDegree();
                nbAmisSelectionnes++;
            }
        }
        
        double moyenneGroupe0 = sommeDegresGroupe0 / tailleEchantillon;
        double moyenneGroupe1 = sommeDegresGroupe1 / nbAmisSelectionnes;
        
        System.out.printf("Degré moyen du Groupe 0 (Individus au hasard) : %.4f%n", moyenneGroupe0);
        System.out.printf("Degré moyen du Groupe 1 (Leurs amis)          : %.4f%n", moyenneGroupe1);
        System.out.printf("Facteur d'augmentation : %.2f x%n", moyenneGroupe1 / moyenneGroupe0);
        
        System.out.println("\nConclusion : Les amis des individus ont statistiquement plus de contacts que les individus eux-mêmes.");
    }
}
