# Configuration de la sortie
set terminal pngcairo size 1000,600 enhanced font 'Verdana,10'
set output 'comparaison_propagation.png'

# Titre et axes
set title "Évolution de la fraction d'infectés selon le scénario d'immunisation"
set xlabel "Temps (jours)"
set ylabel "Fraction de la population infectée (non-immunisée)"
set grid

# Légende
set key top right box opaque

# Styles de lignes
set style line 1 lc rgb '#e41a1c' lt 1 lw 2  # Rouge pour le témoin
set style line 2 lc rgb '#377eb8' lt 1 lw 2  # Bleu pour l'aléatoire
set style line 3 lc rgb '#FF8C00' lt 1 lw 3  # Orange pour le sélectif

# Tracé des courbes à partir du fichier unique "virus_dblp_scenarios.dat"
# Colonne 1 = Temps, Colonne 2 = Témoin, Colonne 3 = Aléatoire, Colonne 4 = Sélectif
plot "virus_dblp_scenarios.dat" using 1:2 with lines ls 1 title "Aucune immunisation", \
     "virus_dblp_scenarios.dat" using 1:3 with lines ls 2 title "Immunisation Aléatoire (50%)", \
     "virus_dblp_scenarios.dat" using 1:4 with lines ls 3 title "Immunisation Sélective (50%)"
