package tpri;

import java.io.IOException;

import org.graphstream.algorithm.Toolkit;
import org.graphstream.graph.Graph;
import org.graphstream.graph.implementations.SingleGraph;
import org.graphstream.stream.file.FileSourceEdge;

public class ReadDblpWithFSE {

	public static void main(String[] args) throws IOException {
		// TODO Auto-generated method stub
		System.setProperty("org.graphstream.ui", "swing"); // utile si tu visualises

        String filename = "com-dblp.ungraph.txt";

        Graph graph = new SingleGraph("DBLP");
        FileSourceEdge fs = new FileSourceEdge();

        fs.addSink(graph);

        try {
            fs.readAll(filename);  // <-- méthode FileSourceEdge
        } finally {
            fs.removeSink(graph);
        }
        
        //Nombre de noeuds et liens (arêtes)
        int n = graph.getNodeCount();
        int m = graph.getEdgeCount();
        
        double avgDegree = Toolkit.averageDegree(graph);
        double clustering = Toolkit.averageClusteringCoefficient(graph);
        
     // Coefficient de clustering d’un graphe aléatoire G(n,p)
        // p = <k> / (n - 1)
        double p = avgDegree / (n - 1);
        double clusteringRandom = p; // pour un ER, C ≈ p

        System.out.println("Lecture terminée !");
        System.out.println("Nombre de nœuds : " + n);
        System.out.println("Nombre d'arêtes : " + m);
        

        System.out.printf("Degré moyen : %.6f%n", avgDegree);
        System.out.printf("Clustering coefficient : %.6f%n", clustering);

        System.out.printf("Clustering réseau aléatoire (même n et degré moyen) : %.10f%n", clusteringRandom);

	}

}
