/*
 *  Simbad - Robxceot Simulator
 *  Copyright (C) 2004 Louis Hugues
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful, 
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 -----------------------------------------------------------------------------
 * $Author: sioulseuguh $ 
 * $Date: 2005/01/08 16:51:30 $
 * $Revision: 1.3 $
 * $Source: /cvsroot/simbad/src/simbad/gui/Console.java,v $
 */
package simbad.gui;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Scanner;

import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneConstants;
import javax.swing.JTextArea;

import jeu.Score;


/**
 * Récupère un fichier de score, affiche les scores de toutes les parties puis stocke le score
 * de la partie actuelle.
 * @author Louis-Pierre Aubert
 * @version 2018-21-12
 */
public class ScoreboardWindow extends JInternalFrame {
	
	final InputStream  FICHIER_SAUVEGARDE_INPUT  = this.getClass().getResourceAsStream("/scores.data");
	final File         FICHIER_SAUVEGARDE        = new File( this.getClass().getResource("/scores.data").getFile() );
	
	ArrayList<Score> scores;
	JTextArea        jTextArea;
	JScrollPane      jScrollPane;
	
	public ScoreboardWindow ( int sizex, int sizey)
	{
		super("Scoreboard");
		createGUI();
		this.setFocusable(false);
		setSize(sizex, sizey);
	
		// DEBUG
		System.out.println(FICHIER_SAUVEGARDE);
		
	}

	private void createGUI ()
	{	
		// Initialisation des variables
		this.scores = new ArrayList<Score>();
		
		// Création des composants de l'interface.
		this.jTextArea   = new JTextArea();
		this.jTextArea.setEditable(false);
		this.jScrollPane = new JScrollPane(this.jTextArea);
		this.jScrollPane.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
		this.add(this.jScrollPane);
		
		// Lecture et affichage des scores.
		InputStream       ips  = FICHIER_SAUVEGARDE_INPUT;
		InputStreamReader ipsr = new InputStreamReader(ips);
		Scanner           sc   = new Scanner(ipsr);
		
		sc.useDelimiter(" \\| |\n");
		
		while ( sc.hasNextLine() )
		{
			try {
				//System.out.println( "[DEBUG] " + sc.next() );
				this.scores.add( new Score( sc.next(), Integer.valueOf(sc.next().trim()) ) );
			}
			catch (Exception e) { }
		
		}
		
		this.updateScoreboard();
		
	}
	
	/** Met à jour l'affichage du tableau des scores
	 */
	public void updateScoreboard ()
	{
		this.jTextArea.setText("");
		this.scores.sort(null);
		
		this.ajouterTexte( String.format( " %-30s\t |  %-20s \n", "Player", "Score" )  );
		this.ajouterTexte( "---------------------------------------------------------------\n");
		
		for ( Score score : this.scores )
		{
			try {
				String nomJoueur = " " + score.getNomJoueur();
				String nbPoints = " " + score.getScore();
				int longNom = nomJoueur.length();
				String ligneScore = String.format( "%"+(-30+longNom)+"s\t | %-20s \n", nomJoueur, nbPoints );
				this.ajouterTexte( ligneScore );
			}
			catch (Exception e) { }
		}
		
	}
	
	public void addScore ( Score score )
	{
		//MessageNewScore mns = new MessageNewScore();
		//boolean canAddScore = mns.displayMessage();
		
		this.scores.add(score);
		
		// Lecture et affichage des scores.
		this.updateScoreboard();
		
		// Sauvegarder les scores
		try { this.sauvegardeScores();
		} catch (FileNotFoundException e) { e.printStackTrace(); }
	
	}
	
	/** Sauvegarde les scores
	 * @throws FileNotFoundException 
	 */
	public void sauvegardeScores () throws FileNotFoundException
	{
		PrintWriter pW = new PrintWriter(FICHIER_SAUVEGARDE);
		
		for ( Score score : this.scores )
		{
			String nomJoueur  = score.getNomJoueur();
			String nbPoints   = "" + score.getScore();
			String ligneScore = String.format("%s | %s", nomJoueur, nbPoints );
			pW.print( ligneScore + "\n" );
		}
		
		pW.close();
		
	}
	
	/** Ajoute du texte dans la zone de texte ( jTextArea ).
	 * @param texte
	 * @return String ( pour debug avec System.out.println )
	 */
	private String ajouterTexte ( String texte )
	{
		this.jTextArea.setText( this.jTextArea.getText() + texte );
		return this.jTextArea.getText();
		
	}
	
}
