package robots;

import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

import simbad.gui.AgentControlGUI;
import simbad.sim.Agent;
import simbad.sim.RobotFactory;
import simbad.sim.SimpleAgent;
import simbad.sim.Simulator;
import simbad.sim.World;

public class RobotJoueur extends Agent
{	
	private final static Color3f COULEUR_PROJECTILES = new Color3f(10,10,255);

	private static final int NB_VIES_MAX = 5;
	
	private AgentControlGUI interfaceGUI;
	
	private int score  = 0;
	private int nbVies = NB_VIES_MAX;
	
	public RobotJoueur( Vector3d pos, String name, Color3f couleur )
	{
		super(pos, name);
		this.setColor(couleur);
		//RobotFactory.addCameraSensor(this);
		
	}
	
	// Appelé quand la simulation "reset"
	public void resetConteurs ()
	{
	    this.score = 0;
	    this.nbVies = NB_VIES_MAX;
	    this.interfaceGUI.majScore(this.score);
	    this.interfaceGUI.majNbVies(this.nbVies);
	    
	}
	
	public void setInterfaceGUI ( AgentControlGUI interfaceGUI )
	{
		this.interfaceGUI = interfaceGUI;
		
	}
	
	public void tirer () {
		
		Point3d pos = new Point3d();
		this.getCoords(pos);
		
		double posXCanon  = pos.getX();
		double posYCanon  = pos.getY();
		double posZCanon  = pos.getZ()-1;
		Vector3d posCanon = new Vector3d(posXCanon, posYCanon, posZCanon);
		
		Projectile projectile = new Projectile(posCanon, 180, COULEUR_PROJECTILES, this, simulator);
		
		//System.out.println(String.format("Projectile crée en [%f,%f,%f]", posXCanon, posYCanon, posZCanon) );
		
	}
	
	public void ajouterPoints( int nbPoints )
	{
		this.score += nbPoints;
		this.interfaceGUI.majScore(this.score);
		//System.out.println("Score : " + this.score );
		
	}
	
	public boolean estVivant() { return this.nbVies > 0; }
	
	public void retirerVie()
	{
		this.nbVies--;
		this.interfaceGUI.majNbVies(this.nbVies);
		//System.out.println("Score : " + this.score );
		
	}
	
	public void performBehavior()
	{
		// Détecter si touché par projectile
		if ( anOtherAgentIsVeryNear() )
		{
			SimpleAgent agent = getVeryNearAgent();
			if ( agent instanceof Projectile )
			{
				Projectile p = (Projectile)agent;
				if ( p.getEquipe() instanceof RobotIA ) this.retirerVie();
				
			}
			
		}
		
		//Toutes les 20 frames
		/*if (getCounter()%20==0)
		{
			Point3d coord = new Point3d();
			this.getCoords(coord);
			
			System.out.println(String.format("PosRobot[%f,%f,%f]", coord.x, coord.y, coord.z ) );
			
		}*/
		
	}
	
}
