package robots;

import javax.media.j3d.Transform3D;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

import objets.Invocateur;
import simbad.sim.Agent;
import simbad.sim.RangeSensorBelt;
import simbad.sim.RobotFactory;
import simbad.sim.SimpleAgent;
import simbad.sim.Simulator;
import simbad.sim.World;

public class RobotIA extends Agent
{	
	private final static double  DUREE_VIE               = 1500;
	private final static double  VITESSE_DEPLACEMENT_MAX = 3;
	private final static int     VALEUR_POINTS           = 100;
	private final static Color3f COULEUR_PROJECTILES     = new Color3f(255,0,0);
	private final static Color3f COULEUR_ROBOT           = new Color3f(0,255,0);
	
	Simulator       simulateur;
	RangeSensorBelt sonars;
	Vector3d        posCanon;
	int             frequenceTir;
	int             vitesse;
	
	// Etats du robot
	boolean tourne;
	char  direction;    // G = Gauche, D = Droit
	int tempsDebutVirage;
	
	public RobotIA ( Vector3d pos, String name, Simulator simulator )
	{
		super(pos, name);
		this.simulateur = simulator;
		this.sonars = RobotFactory.addSonarBeltSensor(this,1);
		this.frequenceTir = (int)(Math.random()*500 + 50);
		this.tourne = true;
		this.direction = 'D';
		this.tempsDebutVirage = 0;
		
		//this.setColor(COULEUR_ROBOT);
		//System.out.println("FreqTir = " + this.frequenceTir);
		
	}
	
	public int getValeurPoints() { return this.VALEUR_POINTS; }
	
	public void tirer ()
	{	
		Point3d pos = new Point3d();
		this.getCoords(pos);
		
		// Les calculs ci-dessous sont nécessaires ! Ils permettent de faire apparaître un projectile sous le robot ( et non à coté ).
		double posXCanon  = pos.getX();
		double posYCanon  = pos.getY();
		double posZCanon;
		if ( this.direction == 'D') posZCanon = pos.getZ()-2;
		else posZCanon = pos.getZ()+2;
		Vector3d posCanon = new Vector3d(posXCanon, posYCanon, posZCanon);
		
		Vector3d rot = this.instantRotation;
		double rotY = rot.getY();
		Projectile projectile = new Projectile(posCanon, rotY, COULEUR_PROJECTILES, this, this.simulateur);
		
		//System.out.println(String.format("Projectile crée en [%f,%f,%f]", posXCanon, posYCanon, posZCanon) );
		
	}
	
	public void performBehavior()
	{
		this.setTranslationalVelocity( VITESSE_DEPLACEMENT_MAX );
		
		// Le supprimer si jamais détruit
		if ( this.getCounter() >= DUREE_VIE ) this.simulateur.removeAgent(this);
		
		// Détecter si touché par projectile
		if ( anOtherAgentIsVeryNear() )
		{
			SimpleAgent agent = getVeryNearAgent();
			if ( agent instanceof Projectile )
			{
				Projectile p = (Projectile)agent;
				if ( p.getEquipe() instanceof RobotJoueur ) this.simulateur.removeAgent(this);
			}
			
		}
		
		// Cas où il fait demi-tour
		if ( this.tourne )
		{
			if ( this.direction == 'D' ) this.setRotationalVelocity(3.0);
			else this.setRotationalVelocity(-3.0);
			
			if ( ( this.tempsDebutVirage - getCounter() ) % 60 == 0 )
			{
				this.setRotationalVelocity(0.0);
				this.tourne = false;
				
				if ( this.direction == 'D' ) this.direction = 'G';
				else this.direction = 'D';
				
			}
			
		}
		// Cas normaux
		else 
		{
			//Toutes les 50 frames
			if ( getCounter() % 50 == 0)
			{
				// Vérifier la distance de l'obstacle devant
				if ( sonars.getMeasurement(0) < 5.0 ) 
				{
					this.tourne = true;
					this.tempsDebutVirage = this.getCounter();
				}
				
			}
			
		}
		
		// Action Tirer
		if ( getCounter()%this.frequenceTir == 0 ) this.tirer();
		
	}
	
}
