package robots;

import javax.vecmath.Color3f;
import javax.vecmath.Vector3d;

import simbad.sim.Agent;
import simbad.sim.BallAgent;
import simbad.sim.SimpleAgent;
import simbad.sim.Simulator;
import simbad.sim.World;

public class Projectile extends BallAgent {

	private final static int VITESSE_MAX = 20; 
	
	private Simulator simulateur;
	private Agent     equipe;
	
	public Projectile ( Vector3d pos, double rot, Color3f couleur, Agent equipe, Simulator simulator ) {
		super(pos, "Projectile", couleur, 0.25f, 1 );
		this.simulateur = simulator;
		this.equipe     = equipe;
		
		// Fait exister l'objet
		this.simulateur.addAgent(this);
		
		double rotRad = Math.toRadians(rot);
		double rotX = VITESSE_MAX * ( Math.sin(rotRad) );
		double rotZ = VITESSE_MAX * ( Math.cos(rotRad) );
		this.linearVelocity = new Vector3d(rotX, 0, rotZ);
		
	}
	
	
	public Agent getEquipe () { return this.equipe; }
	
	public void performBehavior ()
	{
		// Terminer l'agent après un certain temps
		if ( this.getCounter() >= 100 ) this.simulateur.removeAgent(this);
		
		// Détecter les collisions
		if ( anOtherAgentIsVeryNear() )
		{
			SimpleAgent agent = getVeryNearAgent();
			if ( agent instanceof Projectile )
			{
				this.simulateur.removeAgent(this);
			}
			// Détecter si touché par RobotIA pour ajouter des points.
			else if ( (agent instanceof RobotIA && !(this.equipe instanceof RobotIA) ) )
			{
				((RobotJoueur) equipe).ajouterPoints( ((RobotIA) agent).getValeurPoints() );
				this.simulateur.removeAgent(this);
			}
					
		}
		
	}

}
