package objets;

import javax.media.j3d.Shape3D;
import javax.vecmath.Color3f;
import javax.vecmath.Vector3d;

import robots.RobotIA;
import simbad.sim.Agent;
import simbad.sim.BaseObject;
import simbad.sim.SimpleAgent;
import simbad.sim.Simulator;

/**
 * Cette classe est un objet plaçable dans le monde qui fera apparaître des objets comme des robots et des projectiles.
 * Il peut être parenté avec n'importe quels objets.
 * @author louis
 *
 */
public class Invocateur extends Agent {
	
	private Agent     agentParent;
	private Vector3d  pos;
	private Vector3d  posInvoc;
	private int       nbRobot;
	
	public Invocateur ( Vector3d pos, String nom ) {
		super(pos, nom);
		this.setColor( new Color3f(10,10,10) );
		this.pos      = pos;
		this.posInvoc = new Vector3d(this.pos.getX(), this.pos.getY(), this.pos.getZ()+1 );
		nbRobot = 0;
		
	}
	
	public void setSimulator ( Simulator simulator ) { this.simulator = simulator; }
	
	public void performBehavior()
	{
		if ( this.getCounter() % 200 == 0 )
		{
			this.simulator.addAgent( (SimpleAgent)new RobotIA( this.posInvoc, "IA"+this.nbRobot, this.simulator) );
			this.nbRobot++;
			
		}
		
	}

}
