package objets;

import javax.vecmath.Color3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

import jeu.Environnement;
import robots.Projectile;
import robots.RobotJoueur;
import simbad.sim.Agent;
import simbad.sim.Box;
import simbad.sim.SimpleAgent;
import simbad.sim.Simulator;

public class Brique extends Agent {
	
	private static final int     PTS_VIE      = 3;
	private static final Color3f COULEUR_BASE = new Color3f(1.0f,0.5f,0.0f);
	private int                  bouclier;
	
	public Brique ( Vector3d pos, Vector3f taille, Environnement environnement )
	{
		super(pos, taille, "Brique" );
		this.setColor( COULEUR_BASE );
		this.bouclier = PTS_VIE;
		
	}
	
	public void resetConteurs ()
	{
		this.bouclier = PTS_VIE;
		this.setColor( COULEUR_BASE );
	}
	
	public void performBehavior()
	{
		// Détecter si touché par projectile
		if ( anOtherAgentIsVeryNear() )
		{
			SimpleAgent agent = getVeryNearAgent();
			if ( agent instanceof Projectile )
			{
				this.bouclier--;
				
				float coulR = COULEUR_BASE.getX()*(bouclier/PTS_VIE);
				float coulV = COULEUR_BASE.getY()*(bouclier/PTS_VIE);
				float coulB = COULEUR_BASE.getZ()*(bouclier/PTS_VIE);
				this.setColor( new Color3f(coulR,coulV,coulB) );
			}
			if ( this.bouclier <= 0 ) this.detach();
			
		}
			
	}

}
