package jeu;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Scanner;

import javax.vecmath.Color3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

import objets.Brique;
import objets.Invocateur;

import robots.*;

import simbad.sim.BallAgent;
import simbad.sim.Box;
import simbad.sim.CherryAgent;
import simbad.sim.EnvironmentDescription;
import simbad.sim.Wall;

public class Environnement extends EnvironmentDescription
{
	private Scanner sc;
	
	public Environnement ( String fichier )
	{
		try
		{
			InputStream ips = this.getClass().getResourceAsStream(fichier);
        	InputStreamReader ipsr = new InputStreamReader(ips);
        	this.sc = new Scanner(ipsr);

			while ( sc.hasNextLine() )
			{
				this.sc.useDelimiter(" |\\n");
				String objet = sc.next();
				
				if ( objet.equals("Sol") )
				{
					float taille = Float.valueOf(  sc.next() );
					
					String message = String.format("Taille du monde : %f", taille);
					System.out.println(message);
					this.setWorldSize(taille);
				 
				}
				else if ( objet.equals("Mur") )
				{
					double posX     = Double.valueOf(  sc.next() );
					double posY     = Double.valueOf(  sc.next() );
					double posZ     = Double.valueOf(  sc.next() );
					float  longueur = Float.valueOf(   sc.next() );
					float  hauteur  = Float.valueOf(   sc.next() );
					int    rot      = Integer.valueOf( sc.next() );
					
					String message = String.format("Mur: pos[%f,%f,%f] trans[%f,%f] rot[%d]", posX, posY, posZ, longueur, hauteur, rot);
					System.out.println(message);
					Wall w = new Wall( new Vector3d( posX, posY, posZ ), longueur, hauteur, this);
					w.rotate90(rot);
					add(w);
				 
				}
				else if ( objet.equals("Boite") )
				{
					double posX     = Double.valueOf(  sc.next() );
					double posY     = Double.valueOf(  sc.next() );
					double posZ     = Double.valueOf(  sc.next() );
					float  longueur = Float.valueOf(   sc.next() );
					float  hauteur  = Float.valueOf(   sc.next() );
					int    rot      = Integer.valueOf( sc.next() );
					
					String message = String.format("Boîte: pos[%f,%f,%f] trans[%f,%f] rot[%d]", posX, posY, posZ, longueur, hauteur, rot);
					System.out.println(message);
					
					Box b = new Box( new Vector3d( posX, posY, posZ ), new Vector3f(longueur, hauteur, 1),this);
					b.rotateY(rot);
					add(b);
					
				}
				else if ( objet.equals("RobotJoueur") )
				{
					double posX       = Double.valueOf( sc.next() );
					double posY       = Double.valueOf( sc.next() );
					double posZ       = Double.valueOf( sc.next() );
					String nom        = sc.next();
					int    coulRouge  = sc.nextInt();
					int    coulBleu   = sc.nextInt();
					int    coulVerte  = sc.nextInt();
					//double angleRot = Double.valueOf( sc.next() );
					
					Color3f couleur = new Color3f( coulRouge, coulBleu, coulVerte);
					
					String message = String.format("RobotJoueur: pos[%f,%f,%f]", posX, posY, posZ );
					System.out.println(message);
					
					RobotJoueur r = new RobotJoueur( new Vector3d( posX, posY, posZ ), nom, couleur );
					add(r);
					
				}
				else if ( objet.equals("Balle") )
				{
					double posX  = Double.valueOf( (Math.random()*10)-5 );
					double posY  = Double.valueOf( (Math.random()*10)-5 );
					double posZ  = Double.valueOf( 0 );
					float  coulR = Float.valueOf( sc.next() );
					float  coulG = Float.valueOf( sc.next() );
					float  coulB = Float.valueOf( sc.next() );
					float  rayon = Float.valueOf( sc.next() );
					float  masse = Float.valueOf( sc.next() );
					
					String message = String.format("Balle: pos[%f,%f,%f]", posX, posY, posZ );
					System.out.println(message);
					
					BallAgent b = new BallAgent(new Vector3d(posX, posY, posZ), "ball", new Color3f(coulR,coulG,coulB) , rayon, masse);
					add(b);			
				}
				else if ( objet.equals("Cerise") )
				{
					double posX  = Double.valueOf( (Math.random()*10)-5 );
					double posY  = Double.valueOf( (Math.random()*10)-5 );
					double posZ  = Double.valueOf( 0 );
					
					String message = String.format("Cerise: pos[%f,%f,%f]", posX, posY, posZ );
					System.out.println(message);
					
					CherryAgent b = new CherryAgent( new Vector3d(posX, posY, posZ), "cherry", 0.15f);
					add(b);
					
				}
				else if ( objet.equals("Invocateur") )
				{
					double posX = Double.valueOf( sc.next() );
					double posY = Double.valueOf( sc.next() );
					double posZ = Double.valueOf( sc.next() );
					String nom  = sc.next();
					
					String message = String.format("Invocateur: pos[%f,%f,%f]", posX, posY, posZ );
					System.out.println(message);
					Invocateur b = new Invocateur( new Vector3d(posX, posY, posZ), nom );
					add(b);
					
				}
				else if ( objet.equals("Briques") )
				{
					double posX     = Double.valueOf(  sc.next() );
					double posY     = Double.valueOf(  sc.next() );
					double posZ     = Double.valueOf(  sc.next() );
					float  rayon    = Float.valueOf(   sc.next() );
					float  hauteur  = Float.valueOf(   sc.next() );
					
					String message = String.format("Groupe de Briques: pos[%f,%f,%f] trans[%f,%f]", posX, posY, posZ, rayon, hauteur);
					System.out.println(message);
					
					// +---+----------------------------+---+
					// |   |-4 -3 -2 -1  0  1  2  3  4  | X |
					// +---+----------------------------+---+
					// |-2 |          b  b  b           |
					// |-1 |    b  b  b  b  b  b  b     |
					// | 0 | b  b  b  b  b  b  b  b  b  |
					// | 1 | b  b  b           b  b  b  |
					// | 2 | b  b  b           b  b  b  |
					// +---+----------------------------+
					// | Y |
					// +---+
					
					int nbRangees  = 5;
					int nbColonnes = 7;
					
					double decalage = 0.6;
					Vector3f v3f = new Vector3f(rayon, hauteur, rayon);
					
					for ( int cptLig=0; cptLig<nbRangees; cptLig++)
					{
						for ( int cptCol=0; cptCol<nbColonnes; cptCol++)
						{
							if ( ( cptLig==0 &&  cptCol>2  && cptCol<=nbColonnes-4 ) 
							  || ( cptLig==1 &&  cptCol>0  && cptCol<nbColonnes-1  )
							  || ( cptLig==2 )
							  || ( cptLig>2  && (cptCol<2 || cptCol>nbColonnes-3)  ) )
							{
								Vector3d v3d = new Vector3d( posX+(cptCol-(9/2))*0.6 , posY, posZ+(cptLig-(hauteur/2))*0.6 );
								Brique b     = new Brique(v3d, v3f, this);
								add(b);
							}
							
						}
						
					}
					
				}
				this.sc.nextLine();
				
			}
			
		  this.sc.close();
		  
		}
		catch (Exception e) { e.printStackTrace();} 
		
		setUsePhysics(true);
	
	
	}
	
}
