import type { NextConfig } from "next";

const nextConfig: NextConfig = {
  output: "standalone",
  async rewrites() {
    return [
      {
        source: "/api/:path*",
        destination: `${process.env.NEXT_PUBLIC_ENTRYPOINT || "http://php"}/api/:path*`,
      },
    ];
  },
};

export default nextConfig;
