<?php

namespace App\Models;

use ApiPlatform\Metadata\ApiResource;
use ApiPlatform\Metadata\Get;
use ApiPlatform\Metadata\GetCollection;
use ApiPlatform\Metadata\Link;
use ApiPlatform\Metadata\QueryParameter;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use ApiPlatform\Laravel\Eloquent\Filter\EqualsFilter;

#[ApiResource(
    operations: [
        new GetCollection(),
        new Get(
            uriTemplate: '/departments/{department_id}',
            uriVariables: ['department_id' => new Link(fromClass: Department::class, identifiers: ['department_id'])]
        ),
    ]
)]
#[QueryParameter(key: 'department_id', filter: EqualsFilter::class)]
#[QueryParameter(key: 'department_name', filter: EqualsFilter::class)]
#[QueryParameter(key: 'region', filter: EqualsFilter::class)]
class Department extends Model
{
    use HasFactory;
    protected $primaryKey = 'department_id';
    public $incrementing = false;
    protected $keyType = 'string';

    protected $fillable = [
        'department_id',
        'department_name',
        'region_name'
    ];

    protected $hidden = ['taxes'];

    protected $table = 'departments';
    public $timestamps = false;

    /**
     * Get the taxes for the department.
     */
    public function taxes()
    {
        return $this->hasMany(Taxe::class, 'department_id', 'department_id');
    }
}
