<?php

namespace App\Dto;

use ApiPlatform\Metadata\ApiResource;
use ApiPlatform\Metadata\Get;
use ApiPlatform\Metadata\QueryParameter;
use App\State\TaxTimeSeriesProvider;

#[ApiResource(
    shortName: 'TaxTimeSeries',
    paginationEnabled: false,
    operations: [
        new Get(
            uriTemplate: '/taxes/timeseries',
            name: 'tax_timeseries',
            description: 'Get average tax rate evolution by year for a given region',
            provider: TaxTimeSeriesProvider::class,
        ),
    ],
)]
#[QueryParameter(key: 'region', schema: ['type' => 'string'], required: true)]
#[QueryParameter(key: 'tax_type', schema: ['type' => 'string', 'enum' => ['tfpnb', 'tfpb', 'th', 'cfe']], required: true)]
#[QueryParameter(key: 'start_year', schema: ['type' => 'integer'])]
#[QueryParameter(key: 'end_year', schema: ['type' => 'integer'])]
class TaxTimeSeries
{
    public function __construct(
        public readonly string $region = '',
        public readonly string $tax_type = '',
        public readonly ?int $start_year = null,
        public readonly ?int $end_year = null,
        public readonly array $data = [],
    ) {}
}
