<?php

namespace App\Dto;

use ApiPlatform\Metadata\ApiResource;
use ApiPlatform\Metadata\Get;
use ApiPlatform\Metadata\QueryParameter;
use App\State\TaxGlobalStatProvider;

#[ApiResource(
    shortName: 'TaxGlobalStat',
    paginationEnabled: false,
    operations: [
        new Get(
            uriTemplate: '/stats/global',
            name: 'tax_stats_global',
            description: 'Get aggregated tax statistics grouped by department or region',
            provider: TaxGlobalStatProvider::class,
        ),
    ],
)]
#[QueryParameter(key: 'group_by', schema: ['type' => 'string', 'enum' => ['department', 'region']])]
#[QueryParameter(key: 'year', schema: ['type' => 'integer'])]
class TaxGlobalStat
{
    public function __construct(
        public readonly string $group_by = 'department',
        public readonly string|int|null $year = null,
        public readonly array $data = [],
    ) {}
}
