<?php

namespace App\Dto;

use ApiPlatform\Metadata\ApiResource;
use ApiPlatform\Metadata\Get;
use ApiPlatform\Metadata\QueryParameter;
use App\State\TaxFieldStatProvider;

#[ApiResource(
    shortName: 'TaxFieldStat',
    paginationEnabled: false,
    operations: [
        new Get(
            uriTemplate: '/somme/{field}',
            name: 'tax_sum',
            description: 'Calculate the sum of a specific tax field (tfpnb, tfpb, th, cfe)',
            provider: TaxFieldStatProvider::class,
        ),
        new Get(
            uriTemplate: '/average/{field}',
            name: 'tax_average',
            description: 'Calculate the average of a specific tax field (tfpnb, tfpb, th, cfe)',
            provider: TaxFieldStatProvider::class,
        ),
    ],
)]
#[QueryParameter(key: 'department_id', schema: ['type' => 'string'])]
#[QueryParameter(key: 'year', schema: ['type' => 'integer'])]
class TaxFieldStat
{
    public function __construct(
        public readonly string $field = '',
        public readonly ?float $sum = null,
        public readonly ?float $average = null,
        public readonly array $filters = [],
    ) {}
}
