<?php

namespace App\Dto;

use ApiPlatform\Metadata\ApiResource;
use ApiPlatform\Metadata\Get;
use ApiPlatform\Metadata\QueryParameter;
use App\State\RegionDistributionProvider;

#[ApiResource(
    shortName: 'RegionDistribution',
    paginationEnabled: false,
    operations: [
        new Get(
            uriTemplate: '/regions/distribution',
            name: 'region_distribution',
            description: 'Get regional breakdown of collected tax volumes for pie chart',
            provider: RegionDistributionProvider::class,
        ),
    ],
)]
#[QueryParameter(key: 'tax_type', schema: ['type' => 'string', 'enum' => ['tfpnb', 'tfpb', 'th', 'cfe']], required: true)]
#[QueryParameter(key: 'year', schema: ['type' => 'integer'])]
class RegionDistribution
{
    public function __construct(
        public readonly string $tax_type = '',
        public readonly ?int $year = null,
        public readonly array $data = [],
    ) {}
}
