<?php

namespace App\Dto;

use ApiPlatform\Metadata\ApiResource;
use ApiPlatform\Metadata\Get;
use ApiPlatform\Metadata\QueryParameter;
use App\State\CommuneCorrelationProvider;

#[ApiResource(
    shortName: 'CommuneCorrelation',
    paginationEnabled: false,
    operations: [
        new Get(
            uriTemplate: '/communes/correlation',
            name: 'commune_correlation',
            description: 'Get commune-level tax rate vs collected volume for scatter plot',
            provider: CommuneCorrelationProvider::class,
        ),
    ],
)]
#[QueryParameter(key: 'department_id', schema: ['type' => 'string'], required: true)]
#[QueryParameter(key: 'tax_type', schema: ['type' => 'string', 'enum' => ['tfpnb', 'tfpb', 'th', 'cfe']], required: true)]
#[QueryParameter(key: 'year', schema: ['type' => 'integer'], required: true)]
class CommuneCorrelation
{
    public function __construct(
        public readonly string $department_id = '',
        public readonly string $tax_type = '',
        public readonly ?int $year = null,
        public readonly array $data = [],
    ) {}
}
