<?php

namespace App\Models;

use ApiPlatform\Metadata\ApiResource;
use ApiPlatform\Metadata\QueryParameter;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use ApiPlatform\Laravel\Eloquent\Filter\EqualsFilter;

#[ApiResource]
#[QueryParameter(key: 'commune_code', filter: EqualsFilter::class)]
#[QueryParameter(key: 'commune_name', filter: EqualsFilter::class)]
#[QueryParameter(key: 'department_id', filter: EqualsFilter::class)]
#[QueryParameter(key: 'year', filter: EqualsFilter::class)]
#[QueryParameter(key: 'sort[:property]', filter: EqualsFilter::class)]

class Taxe extends Model
{
    use HasFactory;

    // Tax field constants
    public const FIELD_TFPNB = 'tfpnb';
    public const FIELD_TFPB = 'tfpb';
    public const FIELD_TH = 'th';
    public const FIELD_CFE = 'cfe';

    public const ALLOWED_STAT_FIELDS = [
        self::FIELD_TFPNB,
        self::FIELD_TFPB,
        self::FIELD_TH,
        self::FIELD_CFE,
    ];

    public const AMOUNT_FIELDS = [
        'tfpnb_amount' => self::FIELD_TFPNB,
        'tfpb_amount' => self::FIELD_TFPB,
        'th_amount' => self::FIELD_TH,
        'cfe_amount' => self::FIELD_CFE,
    ];

    public const PERCENTAGE_FIELDS = [
        'tfpnb_percentage' => self::FIELD_TFPNB,
        'tfpb_percentage' => self::FIELD_TFPB,
        'th_percentage' => self::FIELD_TH,
        'cfe_percentage' => self::FIELD_CFE,
    ];

    protected $fillable = [
        'commune_code',
        'commune_name',
        'department_id',
        'tfpnb_amount',
        'tfpnb_percentage',
        'tfpb_amount',
        'tfpb_percentage',
        'th_amount',
        'th_percentage',
        'cfe_amount',
        'cfe_percentage',
        'year'
    ];

    protected $casts = [
    'tfpnb_percentage' => 'float',
    'tfpb_percentage' => 'float',
    'th_percentage' => 'float',
    'cfe_percentage' => 'float',
    
    'tfpnb_amount' => 'float',
    'tfpb_amount' => 'float', 
    'th_amount' => 'float',
    'cfe_amount' => 'float',
    ];
    
    protected $table = 'taxes';

    public $timestamps = false;

    /**
     * Get the department that owns the tax record.
     */
    public function department()
    {
        return $this->belongsTo(Department::class, 'department_id', 'department_id');
    }
}
