<?php

namespace App\Models;

use ApiPlatform\Metadata\ApiResource;
use ApiPlatform\Metadata\QueryParameter;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use ApiPlatform\Laravel\Eloquent\Filter\EqualsFilter;

#[QueryParameter(key: 'department_id', filter: EqualsFilter::class)]
#[QueryParameter(key: 'department_name', filter: EqualsFilter::class)]
#[QueryParameter(key: 'region', filter: EqualsFilter::class)]

#[ApiResource]
class Department extends Model
{
    use HasFactory;
    protected $primaryKey = 'department_id';
    public $incrementing = false;
    protected $keyType = 'string';

    protected $fillable = [
        'department_id',
        'department_name',
        'region_name'
    ];
    
    protected $table = 'departments';
    public $timestamps = false;

    /**
     * Get the taxes for the department.
     */
    public function taxes()
    {
        return $this->hasMany(Taxe::class, 'department_id', 'department_id');
    }
}
