<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class TaxStatRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Prepare the data for validation - sanitize inputs.
     */
    protected function prepareForValidation(): void
    {
        $sanitized = [];

        // Sanitize department_id: trim, uppercase, remove non-alphanumeric
        if ($this->has('department_id')) {
            $sanitized['department_id'] = strtoupper(
                preg_replace('/[^0-9A-Za-z]/', '', trim($this->department_id))
            );
        }

        // Sanitize year: convert to integer, remove any non-numeric characters
        if ($this->has('year')) {
            $sanitized['year'] = (int) preg_replace('/[^0-9]/', '', $this->year);
        }

        $this->merge($sanitized);
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'department_id' => 'sometimes|string|min:2|max:3|alpha_num|regex:/^[0-9A-Z]{2,3}$/',
            'year' => 'sometimes|integer|min:2000|max:2100',
        ];
    }
}
