'use client'

import { useState } from 'react'
import { Search } from 'lucide-react'
import Temporal from './components/tabs/temporal'
import Points from './components/tabs/points'
import Diagram from './components/tabs/diagram'

const tabs = [
    { key: 'temporal', label: 'Temporal' },
    { key: 'points', label: 'Points' },
    { key: 'diagram', label: 'Diagram' },
] as const

type TabKey = (typeof tabs)[number]['key']

const tabComponents: Record<TabKey, React.ComponentType> = {
    temporal: Temporal,
    points: Points,
    diagram: Diagram,
}

export default function Home() {
    const [activeTab, setActiveTab] = useState<TabKey>('temporal')
    const ActiveComponent = tabComponents[activeTab]

    return (
        <main className="flex">
            <div className="min-h-screen bg-[#212529] w-fit shrink-0 px-8 py-6 text-white border-r border-[#3a3f44]">
                <div className="w-fit">
                    <div className="flex gap-2 items-center mb-8 w-fit">
                        <div className="flex gap-1 items-end justify-center rounded">
                            <div className="bar h-5 w-1 rounded-full bg-white" style={{ animationDelay: '0s' }}></div>
                            <div className="bar h-3.5 w-1 rounded-full bg-white" style={{ animationDelay: '0.4s' }}></div>
                            <div className="bar h-4.5 w-1 rounded-full bg-white" style={{ animationDelay: '0.8s' }}></div>
                        </div>
                        <h1>FullStack Lab</h1>
                    </div>

                    <div className="flex gap-2 items-center text-[#b0afaf] mb-4">
                        <p className="uppercase text-xs">Visualisation</p>
                    </div>

                    <nav className="flex flex-col gap-1">
                        {tabs.map((tab) => (
                            <button
                                key={tab.key}
                                onClick={() => setActiveTab(tab.key)}
                                className={`text-left text-sm px-3 py-2 rounded transition-colors ${
                                    activeTab === tab.key
                                        ? 'bg-[#181C1F] text-white'
                                        : 'text-[#b0afaf] hover:text-white'
                                }`}
                            >
                                {tab.label}
                            </button>
                        ))}
                    </nav>
                </div>
            </div>

            <div className="w-full flex flex-col min-h-screen">
                <div className="bg-[#212529] w-full h-22 flex items-center gap-4 px-6">
                    <div className="flex flex-col gap-1 hover:cursor-pointer">
                        <div className="w-6 h-0.5 rounded-full bg-[#3a3f44]"></div>
                        <div className="w-6 h-0.5 rounded-full bg-[#3a3f44]"></div>
                        <div className="w-6 h-0.5 rounded-full bg-[#3a3f44]"></div>
                    </div>
                    <div className="relative w-2/6">
                        <Search className="absolute left-3 top-1/2 -translate-y-1/2 text-[#b0afaf]" size={16} />
                        <input
                            className="rounded-full border-[#3a3f44] border-2 w-full pl-9 pr-3 py-1.5 bg-transparent text-white placeholder-[#b0afaf]"
                            placeholder="Search"
                        />
                    </div>
                </div>
                <div className="w-full flex-1 bg-[#181C1F]">
                    <ActiveComponent />
                </div>
            </div>
        </main>
    )
}
