const tabs = [
    { key: 'temporal', label: 'Temporal' },
    { key: 'points', label: 'Points' },
    { key: 'diagram', label: 'Diagram' },
] as const

export type TabKey = (typeof tabs)[number]['key']

interface SidebarProps {
    activeTab: TabKey
    onTabChange: (tab: TabKey) => void
    open: boolean
}

export default function Sidebar({ activeTab, onTabChange, open }: SidebarProps) {
    return (
        <div className={`bg-[#212529] w-fit shrink-0 px-8 py-6 text-white border-r border-[#3a3f44] ${open ? 'block' : 'hidden'} md:block absolute md:relative z-20 h-full md:h-auto`}>
            <div className="w-fit">
                <div className="flex gap-2 items-center mb-8 w-fit">
                    <div className="flex gap-1 items-end justify-center rounded">
                        <div className="bar h-5 w-1 rounded-full bg-white" style={{ animationDelay: '0s' }}></div>
                        <div className="bar h-3.5 w-1 rounded-full bg-white" style={{ animationDelay: '0.4s' }}></div>
                        <div className="bar h-4.5 w-1 rounded-full bg-white" style={{ animationDelay: '0.8s' }}></div>
                    </div>
                    <h1>FullStack Lab</h1>
                </div>

                <div className="flex gap-2 items-center text-[#b0afaf] mb-4">
                    <p className="uppercase text-xs">Visualisation</p>
                </div>

                <nav className="flex flex-col gap-1">
                    {tabs.map((tab) => (
                        <button
                            key={tab.key}
                            onClick={() => onTabChange(tab.key)}
                            className={`text-left text-sm px-3 py-2 rounded transition-colors ${
                                activeTab === tab.key
                                    ? 'bg-[#181C1F] text-white'
                                    : 'text-[#b0afaf] hover:text-white'
                            }`}
                        >
                            {tab.label}
                        </button>
                    ))}
                </nav>
            </div>
        </div>
    )
}
