import { Search } from 'lucide-react'

interface HeaderProps {
    onToggleSidebar: () => void
}

export default function Header({ onToggleSidebar }: HeaderProps) {
    return (
        <div className="bg-[#212529] w-full h-22 flex items-center gap-4 px-6 relative z-20">
            <button
                onClick={onToggleSidebar}
                className="md:hidden flex flex-col gap-1 hover:cursor-pointer"
            >
                <div className="w-6 h-0.5 rounded-full bg-[#3a3f44]"></div>
                <div className="w-6 h-0.5 rounded-full bg-[#3a3f44]"></div>
                <div className="w-6 h-0.5 rounded-full bg-[#3a3f44]"></div>
            </button>
            <div className="relative w-2/6">
                <Search className="absolute left-3 top-1/2 -translate-y-1/2 text-[#b0afaf]" size={16} />
                <input
                    className="rounded-full border-[#3a3f44] border-2 w-full pl-9 pr-3 py-1.5 bg-transparent text-white placeholder-[#b0afaf]"
                    placeholder="Search"
                />
            </div>
        </div>
    )
}
