'use client'

import { useRouter, useSearchParams } from 'next/navigation'
import { YEARS } from '../../constants'

export default function YearSelector() {
    const router = useRouter()
    const searchParams = useSearchParams()
    const current = Number(searchParams.get('year')) || (YEARS[YEARS.length - 1] ?? 2022)

    const handleChange = (e: React.ChangeEvent<HTMLSelectElement>) => {
        const params = new URLSearchParams(searchParams.toString())
        params.set('year', e.target.value)
        router.push(`/?${params}`)
    }

    return (
        <div className="flex flex-col gap-1">
            <label className="text-xs text-[#b0afaf] uppercase">Année</label>
            <select value={current} onChange={handleChange} className="bg-[#212529] border border-[#3a3f44] rounded px-3 py-1.5 text-white text-sm">
                {YEARS.map(y => (
                    <option key={y} value={y}>
                        {y}
                    </option>
                ))}
            </select>
        </div>
    )
}
