'use client'

import { useState } from 'react'
import Sidebar, { type TabKey } from './components/molecules/Sidebar'
import Header from './components/molecules/Header'
import Temporal from './components/tabs/temporal'
import Points from './components/tabs/points'
import Diagram from './components/tabs/diagram'

const tabComponents: Record<TabKey, React.ComponentType> = {
    temporal: Temporal,
    points: Points,
    diagram: Diagram,
}

export default function Home() {
    const [activeTab, setActiveTab] = useState<TabKey>('temporal')
    const [sidebarOpen, setSidebarOpen] = useState(false)
    const ActiveComponent = tabComponents[activeTab]

    return (
        <main className="flex h-screen relative">
            <Sidebar activeTab={activeTab} onTabChange={setActiveTab} open={sidebarOpen} />
            {sidebarOpen && (
                <div
                    className="fixed inset-0 bg-black/50 z-10 md:hidden"
                    onClick={() => setSidebarOpen(false)}
                />
            )}

            <div className="w-full flex flex-col min-w-0">
                <Header onToggleSidebar={() => setSidebarOpen(prev => !prev)} />
                <div className="w-full flex-1 bg-[#181C1F] overflow-auto">
                    <ActiveComponent />
                </div>
            </div>
        </main>
    )
}
