import Dashboard from './components/organisms/Dashboard'

const API_URL = process.env.NEXT_PUBLIC_ENTRYPOINT || 'http://php'

async function getRegions(): Promise<string[]> {
    try {
        const res = await fetch(`${API_URL}/api/regions`)
        if (!res.ok) return []
        const data = await res.json()
        return data.member.map((r: { regionName: string }) => r.regionName)
    } catch {
        return []
    }
}

export default async function Home() {
    const regions = await getRegions()
    return <Dashboard regions={regions} />
}
