'use client'

import { useState } from 'react'
import Sidebar, { type TabKey } from '../molecules/Sidebar'
import Header from '../molecules/Header'
import Temporal from '../tabs/temporal'
import Points from '../tabs/points'
import Diagram from '../tabs/diagram'

interface DashboardProps {
    regions: string[]
}

export default function Dashboard({ regions }: DashboardProps) {
    const [activeTab, setActiveTab] = useState<TabKey>('temporal')
    const [sidebarOpen, setSidebarOpen] = useState(false)

    return (
        <main className="flex h-screen relative">
            <Sidebar activeTab={activeTab} onTabChange={setActiveTab} open={sidebarOpen} />
            {sidebarOpen && <div className="fixed inset-0 bg-black/50 z-10 md:hidden" onClick={() => setSidebarOpen(false)} />}

            <div className="w-full flex flex-col min-w-0">
                <Header onToggleSidebar={() => setSidebarOpen(prev => !prev)} />
                <div className="w-full flex-1 bg-[#181C1F] overflow-auto">
                    {activeTab === 'temporal' && <Temporal regions={regions} />}
                    {activeTab === 'points' && <Points />}
                    {activeTab === 'diagram' && <Diagram regions={regions} />}
                </div>
            </div>
        </main>
    )
}
