<?php

namespace Database\Seeders;

use App\Models\Department;
use Illuminate\Database\Seeder;

class DepartmentSeeder extends Seeder
{
    public function run(): void
    {
        $departments = [
            ['department_id' => '01', 'department_name' => 'Ain', 'region_name' => 'Auvergne-Rhône-Alpes'],
            ['department_id' => '02', 'department_name' => 'Aisne', 'region_name' => 'Hauts-de-France'],
            ['department_id' => '03', 'department_name' => 'Allier', 'region_name' => 'Auvergne-Rhône-Alpes'],
            ['department_id' => '04', 'department_name' => 'Alpes-de-Haute-Provence', 'region_name' => 'Provence-Alpes-Côte d\'Azur'],
            ['department_id' => '05', 'department_name' => 'Hautes-Alpes', 'region_name' => 'Provence-Alpes-Côte d\'Azur'],
            ['department_id' => '06', 'department_name' => 'Alpes-Maritimes', 'region_name' => 'Provence-Alpes-Côte d\'Azur'],
            ['department_id' => '07', 'department_name' => 'Ardèche', 'region_name' => 'Auvergne-Rhône-Alpes'],
            ['department_id' => '08', 'department_name' => 'Ardennes', 'region_name' => 'Grand Est'],
            ['department_id' => '09', 'department_name' => 'Ariège', 'region_name' => 'Occitanie'],
            ['department_id' => '10', 'department_name' => 'Aube', 'region_name' => 'Grand Est'],
            ['department_id' => '11', 'department_name' => 'Aude', 'region_name' => 'Occitanie'],
            ['department_id' => '12', 'department_name' => 'Aveyron', 'region_name' => 'Occitanie'],
            ['department_id' => '13', 'department_name' => 'Bouches-du-Rhône', 'region_name' => 'Provence-Alpes-Côte d\'Azur'],
            ['department_id' => '14', 'department_name' => 'Calvados', 'region_name' => 'Normandie'],
            ['department_id' => '15', 'department_name' => 'Cantal', 'region_name' => 'Auvergne-Rhône-Alpes'],
            ['department_id' => '16', 'department_name' => 'Charente', 'region_name' => 'Nouvelle-Aquitaine'],
            ['department_id' => '17', 'department_name' => 'Charente-Maritime', 'region_name' => 'Nouvelle-Aquitaine'],
            ['department_id' => '18', 'department_name' => 'Cher', 'region_name' => 'Centre-Val de Loire'],
            ['department_id' => '19', 'department_name' => 'Corrèze', 'region_name' => 'Nouvelle-Aquitaine'],
            ['department_id' => '2A', 'department_name' => 'Corse-du-Sud', 'region_name' => 'Corse'],
            ['department_id' => '2B', 'department_name' => 'Haute-Corse', 'region_name' => 'Corse'],
            ['department_id' => '21', 'department_name' => 'Côte-d\'Or', 'region_name' => 'Bourgogne-Franche-Comté'],
            ['department_id' => '22', 'department_name' => 'Côtes-d\'Armor', 'region_name' => 'Bretagne'],
            ['department_id' => '23', 'department_name' => 'Creuse', 'region_name' => 'Nouvelle-Aquitaine'],
            ['department_id' => '24', 'department_name' => 'Dordogne', 'region_name' => 'Nouvelle-Aquitaine'],
            ['department_id' => '25', 'department_name' => 'Doubs', 'region_name' => 'Bourgogne-Franche-Comté'],
            ['department_id' => '26', 'department_name' => 'Drôme', 'region_name' => 'Auvergne-Rhône-Alpes'],
            ['department_id' => '27', 'department_name' => 'Eure', 'region_name' => 'Normandie'],
            ['department_id' => '28', 'department_name' => 'Eure-et-Loir', 'region_name' => 'Centre-Val de Loire'],
            ['department_id' => '29', 'department_name' => 'Finistère', 'region_name' => 'Bretagne'],
            ['department_id' => '30', 'department_name' => 'Gard', 'region_name' => 'Occitanie'],
            ['department_id' => '31', 'department_name' => 'Haute-Garonne', 'region_name' => 'Occitanie'],
            ['department_id' => '32', 'department_name' => 'Gers', 'region_name' => 'Occitanie'],
            ['department_id' => '33', 'department_name' => 'Gironde', 'region_name' => 'Nouvelle-Aquitaine'],
            ['department_id' => '34', 'department_name' => 'Hérault', 'region_name' => 'Occitanie'],
            ['department_id' => '35', 'department_name' => 'Ille-et-Vilaine', 'region_name' => 'Bretagne'],
            ['department_id' => '36', 'department_name' => 'Indre', 'region_name' => 'Centre-Val de Loire'],
            ['department_id' => '37', 'department_name' => 'Indre-et-Loire', 'region_name' => 'Centre-Val de Loire'],
            ['department_id' => '38', 'department_name' => 'Isère', 'region_name' => 'Auvergne-Rhône-Alpes'],
            ['department_id' => '39', 'department_name' => 'Jura', 'region_name' => 'Bourgogne-Franche-Comté'],
            ['department_id' => '40', 'department_name' => 'Landes', 'region_name' => 'Nouvelle-Aquitaine'],
            ['department_id' => '41', 'department_name' => 'Loir-et-Cher', 'region_name' => 'Centre-Val de Loire'],
            ['department_id' => '42', 'department_name' => 'Loire', 'region_name' => 'Auvergne-Rhône-Alpes'],
            ['department_id' => '43', 'department_name' => 'Haute-Loire', 'region_name' => 'Auvergne-Rhône-Alpes'],
            ['department_id' => '44', 'department_name' => 'Loire-Atlantique', 'region_name' => 'Pays de la Loire'],
            ['department_id' => '45', 'department_name' => 'Loiret', 'region_name' => 'Centre-Val de Loire'],
            ['department_id' => '46', 'department_name' => 'Lot', 'region_name' => 'Occitanie'],
            ['department_id' => '47', 'department_name' => 'Lot-et-Garonne', 'region_name' => 'Nouvelle-Aquitaine'],
            ['department_id' => '48', 'department_name' => 'Lozère', 'region_name' => 'Occitanie'],
            ['department_id' => '49', 'department_name' => 'Maine-et-Loire', 'region_name' => 'Pays de la Loire'],
            ['department_id' => '50', 'department_name' => 'Manche', 'region_name' => 'Normandie'],
            ['department_id' => '51', 'department_name' => 'Marne', 'region_name' => 'Grand Est'],
            ['department_id' => '52', 'department_name' => 'Haute-Marne', 'region_name' => 'Grand Est'],
            ['department_id' => '53', 'department_name' => 'Mayenne', 'region_name' => 'Pays de la Loire'],
            ['department_id' => '54', 'department_name' => 'Meurthe-et-Moselle', 'region_name' => 'Grand Est'],
            ['department_id' => '55', 'department_name' => 'Meuse', 'region_name' => 'Grand Est'],
            ['department_id' => '56', 'department_name' => 'Morbihan', 'region_name' => 'Bretagne'],
            ['department_id' => '57', 'department_name' => 'Moselle', 'region_name' => 'Grand Est'],
            ['department_id' => '58', 'department_name' => 'Nièvre', 'region_name' => 'Bourgogne-Franche-Comté'],
            ['department_id' => '59', 'department_name' => 'Nord', 'region_name' => 'Hauts-de-France'],
            ['department_id' => '60', 'department_name' => 'Oise', 'region_name' => 'Hauts-de-France'],
            ['department_id' => '61', 'department_name' => 'Orne', 'region_name' => 'Normandie'],
            ['department_id' => '62', 'department_name' => 'Pas-de-Calais', 'region_name' => 'Hauts-de-France'],
            ['department_id' => '63', 'department_name' => 'Puy-de-Dôme', 'region_name' => 'Auvergne-Rhône-Alpes'],
            ['department_id' => '64', 'department_name' => 'Pyrénées-Atlantiques', 'region_name' => 'Nouvelle-Aquitaine'],
            ['department_id' => '65', 'department_name' => 'Hautes-Pyrénées', 'region_name' => 'Occitanie'],
            ['department_id' => '66', 'department_name' => 'Pyrénées-Orientales', 'region_name' => 'Occitanie'],
            ['department_id' => '67', 'department_name' => 'Bas-Rhin', 'region_name' => 'Grand Est'],
            ['department_id' => '68', 'department_name' => 'Haut-Rhin', 'region_name' => 'Grand Est'],
            ['department_id' => '69', 'department_name' => 'Rhône', 'region_name' => 'Auvergne-Rhône-Alpes'],
            ['department_id' => '70', 'department_name' => 'Haute-Saône', 'region_name' => 'Bourgogne-Franche-Comté'],
            ['department_id' => '71', 'department_name' => 'Saône-et-Loire', 'region_name' => 'Bourgogne-Franche-Comté'],
            ['department_id' => '72', 'department_name' => 'Sarthe', 'region_name' => 'Pays de la Loire'],
            ['department_id' => '73', 'department_name' => 'Savoie', 'region_name' => 'Auvergne-Rhône-Alpes'],
            ['department_id' => '74', 'department_name' => 'Haute-Savoie', 'region_name' => 'Auvergne-Rhône-Alpes'],
            ['department_id' => '75', 'department_name' => 'Paris', 'region_name' => 'Île-de-France'],
            ['department_id' => '76', 'department_name' => 'Seine-Maritime', 'region_name' => 'Normandie'],
            ['department_id' => '77', 'department_name' => 'Seine-et-Marne', 'region_name' => 'Île-de-France'],
            ['department_id' => '78', 'department_name' => 'Yvelines', 'region_name' => 'Île-de-France'],
            ['department_id' => '79', 'department_name' => 'Deux-Sèvres', 'region_name' => 'Nouvelle-Aquitaine'],
            ['department_id' => '80', 'department_name' => 'Somme', 'region_name' => 'Hauts-de-France'],
            ['department_id' => '81', 'department_name' => 'Tarn', 'region_name' => 'Occitanie'],
            ['department_id' => '82', 'department_name' => 'Tarn-et-Garonne', 'region_name' => 'Occitanie'],
            ['department_id' => '83', 'department_name' => 'Var', 'region_name' => 'Provence-Alpes-Côte d\'Azur'],
            ['department_id' => '84', 'department_name' => 'Vaucluse', 'region_name' => 'Provence-Alpes-Côte d\'Azur'],
            ['department_id' => '85', 'department_name' => 'Vendée', 'region_name' => 'Pays de la Loire'],
            ['department_id' => '86', 'department_name' => 'Vienne', 'region_name' => 'Nouvelle-Aquitaine'],
            ['department_id' => '87', 'department_name' => 'Haute-Vienne', 'region_name' => 'Nouvelle-Aquitaine'],
            ['department_id' => '88', 'department_name' => 'Vosges', 'region_name' => 'Grand Est'],
            ['department_id' => '89', 'department_name' => 'Yonne', 'region_name' => 'Bourgogne-Franche-Comté'],
            ['department_id' => '90', 'department_name' => 'Territoire de Belfort', 'region_name' => 'Bourgogne-Franche-Comté'],
            ['department_id' => '91', 'department_name' => 'Essonne', 'region_name' => 'Île-de-France'],
            ['department_id' => '92', 'department_name' => 'Hauts-de-Seine', 'region_name' => 'Île-de-France'],
            ['department_id' => '93', 'department_name' => 'Seine-Saint-Denis', 'region_name' => 'Île-de-France'],
            ['department_id' => '94', 'department_name' => 'Val-de-Marne', 'region_name' => 'Île-de-France'],
            ['department_id' => '95', 'department_name' => 'Val-d\'Oise', 'region_name' => 'Île-de-France'],
            ['department_id' => '971', 'department_name' => 'Guadeloupe', 'region_name' => 'Guadeloupe'],
            ['department_id' => '972', 'department_name' => 'Martinique', 'region_name' => 'Martinique'],
            ['department_id' => '973', 'department_name' => 'Guyane', 'region_name' => 'Guyane'],
            ['department_id' => '974', 'department_name' => 'La Réunion', 'region_name' => 'La Réunion'],
            ['department_id' => '976', 'department_name' => 'Mayotte', 'region_name' => 'Mayotte'],
            ['department_id' => '977', 'department_name' => 'Saint-Barthélemy', 'region_name' => 'Saint-Barthélemy'],
            ['department_id' => '978', 'department_name' => 'Saint-Martin', 'region_name' => 'Saint-Martin'],
        ];

        foreach ($departments as $department) {
            Department::updateOrCreate(
                ['department_id' => $department['department_id']],
                $department
            );
        }

        $this->command->info('Seeded ' . count($departments) . ' departments.');
    }
}
