<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('taxes', function (Blueprint $table) {
            $table->id();
            $table->string('commune_code', 5); 
            $table->string('commune_name');
            $table->string('department_id', 3);
            $table->decimal('tfpnb_amount', 15, 2);
            $table->decimal('tfpnb_percentage', 15, 5);
            $table->decimal('tfpb_amount', 15, 2);
            $table->decimal('tfpb_percentage', 15, 5);
            $table->decimal('th_amount', 15, 2);
            $table->decimal('th_percentage', 15, 5);
            $table->decimal('cfe_amount', 15, 2);
            $table->decimal('cfe_percentage', 15, 5);
            $table->integer('year');
        });

        Schema::create('departments', function (Blueprint $table) {
            $table->string('department_id', 3)->primary();
            $table->string('department_name');
            $table->string('region_name');
        });


        Schema::table('taxes', function (Blueprint $table) {
            $table->foreign('department_id')->references('department_id')->on('departments');
        });
    }
    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('taxes');
        Schema::dropIfExists('departments');
    }
};
