<?php

namespace App\Dto;

use ApiPlatform\Metadata\ApiResource;
use ApiPlatform\Metadata\Get;
use ApiPlatform\Metadata\QueryParameter;
use ApiPlatform\OpenApi\Model\Operation;
use ApiPlatform\OpenApi\Model\Response;
use App\State\TaxTimeSeriesProvider;

#[ApiResource(
    shortName: 'TaxTimeSeries',
    description: 'Average tax rate evolution by year for a given region',
    paginationEnabled: false,
    operations: [
        new Get(
            uriTemplate: '/taxes/timeseries',
            name: 'tax_timeseries',
            openapi: new Operation(
                summary: 'Get average tax rate evolution by year for a given region',
                description: 'Returns average tax rate per year for a given region and tax type, with optional year range.',
                responses: [
                    '200' => new Response(description: 'Array of years with their average tax rate'),
                    '400' => new Response(description: 'Invalid or missing parameters (region and tax_type are required)'),
                ],
            ),
            provider: TaxTimeSeriesProvider::class,
        ),
    ],
)]
#[QueryParameter(key: 'region', description: 'French region name (e.g. Normandie, Île-de-France)', schema: ['type' => 'string'], required: true)]
#[QueryParameter(key: 'tax_type', description: 'Tax type to analyze', schema: ['type' => 'string', 'enum' => ['tfpnb', 'tfpb', 'th', 'cfe']], required: true)]
#[QueryParameter(key: 'start_year', description: 'Start year for the range (default: earliest available)', schema: ['type' => 'integer'])]
#[QueryParameter(key: 'end_year', description: 'End year for the range (default: latest available)', schema: ['type' => 'integer'])]
class TaxTimeSeries
{
    public function __construct(
        public readonly string $region = '',
        public readonly string $tax_type = '',
        public readonly ?int $start_year = null,
        public readonly ?int $end_year = null,
        public readonly array $data = [],
    ) {}
}
