


package org.example;

import org.graphstream.algorithm.Toolkit;
import org.graphstream.graph.*;
import org.graphstream.graph.implementations.*;
import org.graphstream.stream.file.FileSourceEdge;

public class DBLPNetworkAnalysis {
        public static void main(String[] args) throws Exception {
            String filePath = "path_to_your_file.txt"; // Chemin du fichier d'entrée
            Graph graph = new SingleGraph("DBLP Collaboration Network");

            // Chargement des données
            FileSourceEdge fileSource = new FileSourceEdge();
            fileSource.addSink(graph);

            try {
                fileSource.readAll(filePath);
            } finally {
                fileSource.removeSink(graph);
            }

            // Mesures de base
            int nodeCount = graph.getNodeCount();
            int edgeCount = graph.getEdgeCount();
            double averageDegree = Toolkit.averageDegree(graph);
            double clusteringCoefficient = Toolkit.averageClusteringCoefficient(graph);

            // Coefficient de clustering pour un graphe aléatoire
            double randomClusteringCoefficient = averageDegree / nodeCount;

            // Affichage des résultats
            System.out.println("Nombre de nœuds : " + nodeCount);
            System.out.println("Nombre de liens : " + edgeCount);
            System.out.println("Degré moyen : " + averageDegree);
            System.out.println("Coefficient de clustering (réel) : " + clusteringCoefficient);
            System.out.println("Coefficient de clustering (aléatoire) : " + randomClusteringCoefficient);
        }
    }
