package org.example;

import org.graphstream.graph.*;
import org.graphstream.graph.implementations.*;
import org.graphstream.stream.file.FileSourceEdge;

import java.io.FileWriter;
import java.util.HashMap;
import java.util.Map;

public class DBLPNetworkAnalysis {
    public static void main(String[] args) throws Exception {
        String filePath = "/home/c2i/IdeaProjects/TP_RI/com-dblp.ungraph.txt"; // Chemin du fichier d'entrée
        Graph graph = new SingleGraph("DBLP Collaboration Network");

        // Chargement des données
        FileSourceEdge fileSource = new FileSourceEdge();
        fileSource.addSink(graph);

        try {
            fileSource.readAll(filePath);
        } finally {
            fileSource.removeSink(graph);
        }

        // Mesures de base
        int nodeCount = graph.getNodeCount();
        DegreeDistribution.calculateDegreeDistribution(graph, "degree_distribution.txt", nodeCount);
    }

    public static class DegreeDistribution {
        public static void calculateDegreeDistribution(Graph graph, String outputFile, int nodeCount) throws Exception {
            Map<Integer, Integer> degreeCounts = new HashMap<>();

            // Comptabiliser les degrés
            for (Node node : graph) {
                int degree = node.getDegree();
                degreeCounts.put(degree, degreeCounts.getOrDefault(degree, 0) + 1);
            }

            // Calculer la probabilité pour chaque degré
            try (FileWriter writer = new FileWriter(outputFile)) {
                writer.write("Degree\tProbability\n");
                for (Map.Entry<Integer, Integer> entry : degreeCounts.entrySet()) {
                    int degree = entry.getKey();
                    int count = entry.getValue();
                    double probability = (double) count / nodeCount; // Probabilité = Nombre de nœuds avec ce degré / Nombre total de nœuds
                    writer.write(degree + "\t" + probability + "\n");
                }
            }

            System.out.println("Distribution des degrés avec probabilités enregistrée dans : " + outputFile);
        }
    }
}
