package org.example;

import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.implementations.SingleGraph;
import org.graphstream.stream.file.FileSourceEdge;

public class Propagation {

    public static void main(String[] args) throws Exception {
        String filePath = "C:/Users/celia/IdeaProjects/TP_RI/com-dblp.ungraph.txt/com-dblp.ungraph.txt";
        Graph graph = new SingleGraph("DBLP Collaboration Network");

        // --- Chargement des données ---
        FileSourceEdge fileSource = new FileSourceEdge();
        fileSource.addSink(graph);
        try {
            fileSource.readAll(filePath);
        } finally {
            fileSource.removeSink(graph);
        }

        // --- Paramètres ---
        double infectionProbability = 1.0; // β = 1
        double recoveryProbability = 0.5; // μ = 0.5

        // --- Calcul et analyse ---
        epidemicThresholdAnalysis(graph, infectionProbability, recoveryProbability);
    }

    private static void epidemicThresholdAnalysis(Graph graph, double infectionRate, double recoveryRate) {
        double avgDegree = calculateAverageDegree(graph);
        double avgDegreeSquared = calculateAverageDegreeSquared(graph);

        // Calcul du taux de propagation et du seuil épidémique
        double tau = infectionRate / recoveryRate; // Taux de propagation
        double c = avgDegree / avgDegreeSquared;   // Seuil épidémique

        // Affichage des résultats
        System.out.println("Taux de propagation (τ) : " + tau);
        System.out.println("Seuil épidémique (c) : " + c);

        // Prédiction
        if (tau > c) {
            System.out.println("La maladie persiste (τ > c).");
        } else {
            System.out.println("La maladie disparaît (τ < c).");
        }
    }

    private static double calculateAverageDegree(Graph graph) {
        int totalDegree = 0;
        for (Node node : graph) {
            totalDegree += node.getDegree();
        }
        return (double) totalDegree / graph.getNodeCount();
    }

    private static double calculateAverageDegreeSquared(Graph graph) {
        double totalDegreeSquared = 0;
        for (Node node : graph) {
            totalDegreeSquared += Math.pow(node.getDegree(), 2);
        }
        return totalDegreeSquared / graph.getNodeCount();
    }
}
