package Bubulle;

import Bubulle.Bulle;

public class Angle {

	//Retourne si l'angle AB-AC est inférieur à inf (en degre)
	public static boolean angle(double[] coordA, double[] coordB, double[] coordC, double inf) {
		if(coordA.length < 3 && coordB.length < 3 && coordC.length < 3)
			return angle(coordA[0], coordA[1], coordA[2], coordB[0], coordB[1], coordB[2], coordC[0], coordC[1], coordC[2], inf);
		return false;
	}
	
	//Cas spécial pour les bulles
	public static boolean angle(Bulle a, Bulle b, Bulle c, double inf) {
		return angle(a.getX(), a.getY(), a.getZ(), b.getX(), b.getY(), b.getZ(), c.getX(), c.getY(), c.getZ(), inf);
	}
	
	public static double degre(Bulle a, Bulle b, Bulle c) {
		return degre(a.getX(), a.getY(), a.getZ(), b.getX(), b.getY(), b.getZ(), c.getX(), c.getY(), c.getZ());
	}
	
	public static double degre(double xA, double yA, double zA, double xB, double yB, double zB, double xC, double yC, double zC) {
		double normAB, normAC, tmp, cosA, angleA;
		double[] AC, AB;
		AC = new double[3];
		AB = new double[3];
		
		
		// A=acos( AB.AC / ( ||AB|| * ||AC||))
		// AB.AC = ABx * ACx + ABy * ACy + ABz * ACz
		// ||AB|| = sqrt(ABx^2 + ABy^2 + ABz^2)
		// ||AC|| = sqrt(ACx^2 + ACy^2 + ACz^2)
		
		
		AB[0] = xB - xA; AB[1] = yB - yA; AB[2] = zB - zA;
		AC[0] = xC - xA; AC[1] = yC - yA; AC[2] = zC - zA;
		

		normAB = Math.sqrt(Math.pow( AB[0] , 2) + Math.pow( AB[1] , 2) + Math.pow( AB[2] , 2));
		normAC = Math.sqrt(Math.pow( AC[0] , 2) + Math.pow( AC[1] , 2) + Math.pow( AC[2] , 2));
		
		tmp = AB[0] * AC[0] + AB[1] * AC[1] + AB[2] * AC[2];
		
		cosA = tmp / (normAB * normAC);
		
		angleA = Math.acos(cosA) * 180 / Math.PI;
		
		
		return angleA;
	}
	
	
	//Retourne si l'angle AB-AC est inférieur à inf (en degre)
	public static boolean angle(double xA, double yA, double zA, double xB, double yB, double zB, double xC, double yC, double zC, double inf) {
		
		//Vérification de l'angle inférieur (ou egal) à la valeur attendu
		return degre(xA,yA,zA, xB,yB,zB, xC,yC,zC) <= inf;
	}

	public static void main(String[] args) {
		
		angle(0,0,0 , 0,1,0 , 0,-1,0, 180);
		
		angle(0,0,0 , 0,1,0 , 0,-1,1, 180);
		
		angle(0,0,0 , 0,1,0 , 0,0,1, 180);
		
		angle(0,0,0 , 0,1,0 , 0,1,1, 180);
		
		angle(0,0,0 , 0,1,0 , 0,1,0, 180);
		
	}
	
}
