/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package Bubulle;

import java.util.ArrayList;
import static org.lwjgl.opengl.GL11.glColor3f;

public class Trajectoire implements Comparable<Trajectoire>{
    ArrayList<Bulle> list;
    double score;

    private float r=0f, g=0f, b=1f;
    
    public Trajectoire() {
        this.list = new ArrayList<Bulle>();
        this.score = 0;
    }
    
    //Constructeur par recopie
    public Trajectoire(Trajectoire t) {
    	this.score = t.score;
    	this.list = new ArrayList<Bulle>();
    	
    	for(Bulle b : t.list)
    		this.list.add(b);
    }
    
    public ArrayList<Bulle> getList() {
        return list;
    }

    public void add(Bulle b) {
        this.list.add(b);
    }
    
    public void add(ArrayList<Bulle> listBulle) {
    	
    	for(Bulle b : listBulle) {
    		list.add(b);
    	}
    	
    }

    public double getScore() {
        return score;
    }

    public void setScore(double score) {
        this.score = score;
    }
    
    public ArrayList<Bulle> removeLast() {
    	
    	ArrayList<Bulle> tmp = new ArrayList<Bulle>();
    	
    	for(int i = 0; i < this.list.size()-1; i++)
    		tmp.add(this.list.get(i));
    	
    	return tmp;
    	
    	
    	//return this.list.remove(this.list.size() - 1);
    }
    
    //Retourne la présence (ou non) d'une bulle dans la trajectoire
    public boolean contains(Bulle b) {   
    	//Si la liste contient des bulles
    	if(!list.isEmpty()) {
    		//Parcours de la liste
    		for(Bulle a : list) {
    			//Si son identifiant unique est déja présent
    			if(a.getId() == b.getId())
    				return true;
    		}
    	}
    	return false;
    }
    
  //Retourne le dernier element de la liste
    public Bulle getLast() {   
        if(!list.isEmpty()) {
            return this.getList().get(this.getList().size()-1);
    	}
    	return null;
    }
    
  //Retourne le i dernier element
    public Bulle getElementPosition(int i) {   
    	return this.getList().get(this.list.size()-i);
    }
    
    public int size() {
    	return this.list.size();
    }
    
    public void setRGB(float r, float g, float b){
        this.r = r;
        this.g = g;
        this.b = b;
    }
    
    public void glcolor(){
        glColor3f(this.r, this.g, this.b);
    }
        
    @Override
    public String toString(){
        String ret = "[";
        
        for(Bulle b : list){
            ret += b.getId() + ", ";
        }
        ret += "]";
        
        return ret;
    }

    @Override
    public int compareTo(Trajectoire o) {
        if(this.score > o.score)
                return 1;
        return -1;
    }
}
