package Bubulle;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

public class Tracker {

	//régularité
	//plus les angles identiques = score bas
	//plus distance identiques = score bas
	//ATTENTION !!! b3 et b4 --> 2 delta t

	private static ArrayList<Trajectoire> solution = new ArrayList<Trajectoire>();
	private static ArrayList<Trajectoire> soluceFinal = new ArrayList<Trajectoire>();
	private static ArrayList<Bulle> population;
	private static final double ANGLE = 20;
	private static final double DISTANCE = 60;

	private static Trajectoire tracer;


	public static void main(String[] args) throws IOException {

		String name;
		
		System.out.println("Début");
		
		if(args.length == 0) {
			
			String prefixe =  "NORMA_50HZ_DT1-8_00";
			String ext = ".txt";
			String act = "";
			int numero = 1;
			
			//Correctif du numero du fichier
			if(numero < 10)
				act = "000"+numero;
			else if (numero < 100)
				act = "00"+numero;
			else if (numero < 1000)
				act = "0"+numero;
			else if (numero < 10000)
				act = ""+numero;
			
			
			 name = prefixe+act+ext;
		}
		else {
			name = args[0];
		}
		
		
		//Lecture et stockage en mémoire de toute les bulles
		Bubulles.creerBulle(name);

		System.out.println("Fin lecture fichier");
		
		demarrage(Bubulles.population);
		
		System.out.println("Fin recherche de trajectoire");
		
		elagage();
		
		System.out.println("Fin élagage");
		
		Ecrire.ecrire("Resultat_"+name, soluceFinal);
		
                /** 3D **/
		
                colorisation();
                
                try {
                    Engine windo = new Engine("Bubulles", 800, 700, population, soluceFinal);
                    windo.run();
                } catch (Exception excp) {
                    excp.printStackTrace();
                    System.exit(-1);
                }
                
                
                /*******/
	}
        
        private static void colorisation(){
            
            for(Trajectoire t : soluceFinal){
                float r = (float)Math.random();
                float g = (float)Math.random();
                float b = (float)Math.random();
                
                t.setRGB(r, g, b);
                
                for(Bulle bu : t.getList()){
                    bu.setRGB(r, g, b);
                }
            }
            
            //Math.random()
        }
	
	//Trie la liste de solution selon le score
	private static void trie() {
		for(Trajectoire t : solution)
			score(t);		
		Collections.sort(solution);
	}

	private static final ArrayList<Bulle> debug = new ArrayList<>();
	
	//Suppression des solutions en trop (mauvais score)
	private static void elagage(){
		
		//Copie de la liste de bulle d'origine
		ArrayList<Bulle> presentes = new ArrayList<>();
                
		for(Bulle b : population)
			presentes.add(b);
		
		trie();
		
		//Parcours des trajectoires ordonnées
		for(Trajectoire t : solution) {
			
			boolean valid = true;
			
			//Parcours des bulles de la trajectoire actuelles
			for(Bulle b : t.getList()) {
				
				//Si encore valide et la bulle n'est pas utilisé
				if(valid && presentes.contains(b)){
					presentes.remove(b);
				}
				else {
					valid = false;
				}
				
			}
			
			if(valid)
                            soluceFinal.add(t);
		}
		
		
	}
	
	//Calcul du score
	private static void score(Trajectoire t) {

		ArrayList<Bulle> list = t.getList();
		double score = 0.0;

		//Angle
		for(int i = 0; i < 2; i++) {
			score+= Math.abs( Angle.degre(list.get(i), list.get(i+1), list.get(i+2)) - Angle.degre(list.get(i+1), list.get(i+2), list.get(i+3)) );
		}

		//Distance
		for(int i = 0; i < 3; i++) {
			score+= Math.abs( list.get(i).distanceXYZ(list.get(i+1)) - list.get(i+1).distanceXYZ(list.get(i+2)) );
		}

		t.setScore(score);
	}
	
	private static void demarrage(ArrayList<Bulle> popInit) {

		population = popInit;
		tracer = new Trajectoire();
		init4();
	}
	

	private static ArrayList<Bulle> travail; 

	//Initialisation
	private static void init4() {

		//Récupére les bulles qui sont à portée possible
		population.stream().forEach((b) -> {

			travail = getList(b.getId()-1);

			if(travail.size() > 4){

                            tracer = new Trajectoire();
                            tracer.add(b);


                            backtracking4(b.getId());
			}

		});

	}

	private static boolean backtracking4(int id) {

		boolean val = false;

		//Pour toute les bulles de travail
		for(Bulle b : travail){

			//Si la bulle n'existe pas déja dans le tracer (cas doublon)
			if(!tracer.contains(b)){

				
				double tmpDist;
				double tmpAng;

				//Cas du décalage entre la bulle 3 et la bulle 4
				if(tracer.size() != 3){
					tmpDist = DISTANCE;
					tmpAng = ANGLE;
				}else{
					tmpDist = DISTANCE*2;
					tmpAng = ANGLE *2;
				}

				//Si la distance est correct
				if( isCorrectDistance(population.get(id),b, tmpDist) ){
					
                                    //Si on a assez de bulles pour tester un angle
                                    if(tracer.size() > 1) {

                                        //Bulle à tester pour l'angle						
                                        Bulle bulleA = tracer.getList().get(tracer.size()-2);
                                        Bulle bulleB = tracer.getList().get(tracer.size()-1);
                                        Bulle bulleC = b;


                                        if(Angle.angle(bulleA, bulleB, bulleC, tmpAng)) {
                                                val = true;
                                        }
                                    }
                                    else{
                                        val = true;
                                    }
				}
				
				// FIN TODO


				// La bulle peut étre dans une trajectoire
				if(val){

                                    tracer.add(b);

                                    //Cas de la dernière bulle d'une trajectoire
                                    if(tracer.size() >= 5)
                                    {

                                            solution.add(tracer);

                                            //Problème de recopie
                                            Trajectoire tmp = new Trajectoire();
                                            tmp.add(tracer.removeLast());
                                            tracer = new Trajectoire(tmp);

                                    }else{
                                            backtracking4(id);
                                    }

				}

			}

		}

		return val;
	}


	private static ArrayList<Bulle> getList(int id){

		Bulle travail = population.get(id);
		ArrayList<Bulle> tmp = new ArrayList<>();

		for(Bulle b : population){
			if(b.getId() != travail.getId()){
				if(travail.distanceXYZ(b) <= DISTANCE * 5){
					tmp.add(b);
				}
			}
		}

		return tmp;
	}

	private static boolean isCorrectDistance(Bulle b, Bulle t, double dist){

		if(b.getId() != t.getId()){

			double tmp = t.distanceXYZ(b);

			//TODO A modi min et max
			if(tmp >= 0 && tmp <= dist) return true;
		}

		return false;
	}


} 
