/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package Bubulle;

import org.lwjgl.glfw.*;
import org.lwjgl.opengl.*;
import org.lwjgl.system.*;

import java.nio.*;
import java.util.ArrayList;
import org.joml.Matrix4f;
import org.lwjgl.BufferUtils;

import static org.lwjgl.glfw.Callbacks.*;
import static org.lwjgl.glfw.GLFW.*;
import static org.lwjgl.opengl.GL11.*;
import static org.lwjgl.system.MemoryStack.*;
import static org.lwjgl.system.MemoryUtil.*;

/**
 *
 * @author dc120883
 */
public class Engine {
    
    public static final int TARGET_FPS = 75;
    
    private long window;
    
    private String windowTitle;
    private int width, height;
    
    private static ArrayList<Bulle> population;
    private static ArrayList<Trajectoire> soluceFinal;
    
    private Camera camera;
    
    public Engine(String windowTitle, int width, int height, ArrayList<Bulle> population, ArrayList<Trajectoire> soluceFinal) throws Exception {
        this.width = width;
        this.height = height;
        this.windowTitle = windowTitle;
        this.population = population;
        this.soluceFinal = soluceFinal;
    }
    
    public void run() {
        try {
            init(); // Création
            loop(); // Boucle d'affichage
        } catch (Exception excp) {
            excp.printStackTrace();
        } finally {
            cleanup(); // Fin
        }
    }
    
    private void init(){
        
        // Setup an error callback. The default implementation
        // will print the error message in System.err.
        GLFWErrorCallback.createPrint(System.err).set();

        // Initialize GLFW. Most GLFW functions will not work before doing this.
        if ( !glfwInit() ) throw new IllegalStateException("Unable to initialize GLFW");

        // Configure GLFW
        glfwDefaultWindowHints(); // optional, the current window hints are already the default
        glfwWindowHint(GLFW_VISIBLE, GLFW_FALSE); // the window will stay hidden after creation
        glfwWindowHint(GLFW_RESIZABLE, GLFW_TRUE); // the window will be resizable
        
        window = glfwCreateWindow(this.width, this.height, this.windowTitle, NULL, NULL);
	if ( window == NULL )
            throw new RuntimeException("Failed to create the GLFW window");
                
        // esc = quit
        // Setup a key callback. It will be called every time a key is pressed, repeated or released.
        glfwSetKeyCallback(window, (window, key, scancode, action, mods) -> {
                if ( key == GLFW_KEY_ESCAPE && action == GLFW_RELEASE )
                        glfwSetWindowShouldClose(window, true); // We will detect this in the rendering loop
        });

        // Get the thread stack and push a new frame
        try ( MemoryStack stack = stackPush() ) {
            IntBuffer pWidth = stack.mallocInt(1); // int*
            IntBuffer pHeight = stack.mallocInt(1); // int*

            // Get the window size passed to glfwCreateWindow
            glfwGetWindowSize(window, pWidth, pHeight);

            // Get the resolution of the primary monitor
            GLFWVidMode vidmode = glfwGetVideoMode(glfwGetPrimaryMonitor());

            // Center the window
            glfwSetWindowPos(
                    window,
                    (vidmode.width() - pWidth.get(0)) / 2,
                    (vidmode.height() - pHeight.get(0)) / 2
            );
        } // the stack frame is popped automatically

        camera = new Camera(this.width/100, this.height/100);
        
        // Make the OpenGL context current
        glfwMakeContextCurrent(window);
        // Enable v-sync
        glfwSwapInterval(1);
        
        // Make the window visible
        glfwShowWindow(window);
        
    }
    
    private void loop(){
        GL.createCapabilities();

        // Run the rendering loop until the user has attempted to close
        // the window or has pressed the ESCAPE key.
        while ( !glfwWindowShouldClose(window) ) {
            glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT); // clear the framebuffer

            /** Code avec rendu en opengl **/

            glPointSize(2); //TMP
            
            int cpt = 0;
            
            //Affiche toutes les bulles
            for(Bulle b : population){
                b.affichage();
                cpt++;
            }
            
            //Affiche les trajectoire valide
            for(Trajectoire t : soluceFinal){
                
                t.glcolor();
                
                Bulle[] b = new Bulle[5];
                int tmp = 0;
                
                for(Bulle bu : t.getList()){
                    b[tmp] = bu;
                    tmp++;
                }
                
                glBegin(GL_LINES);
                
                    for(int i=0; i<4; i++){
                        glVertex3d(b[i].getX()/1000,b[i].getY()/1000,b[i].getZ()/1000);
                        glVertex3d(b[i+1].getX()/1000,b[i+1].getY()/1000,b[i+1].getZ()/1000);
                    }
                    
                glEnd();
            }

            System.out.println(cpt);
            
            // 3d
            glClearColor(1.0f, 1.0f, 1.0f, 0.0f);
            glBegin(GL_LINES);
                glVertex2i(0,0);glVertex2i(0,1);
                glVertex2i(0,0);glVertex2i(1,0);
                glVertex2i(0,0);glVertex3i(0,0,1);
            glEnd();
            
            // Test 1
            /*FloatBuffer fb = BufferUtils.createFloatBuffer(16);
            Matrix4f m = new Matrix4f();
            m.setPerspective((float) Math.toRadians(45.0f), 1.0f, 0.01f, 100.0f);
            glMatrixMode(GL_PROJECTION);
            glLoadMatrixf(m.get(fb));
            m.setLookAt(0.0f, 0.0f, 10.0f,
                        0.0f, 0.0f, 0.0f,
                        0.0f, 1.0f, 0.0f);
            glMatrixMode(GL_MODELVIEW);
            glLoadMatrixf(m.get(fb));*/
            // End Test 1
            
            glMatrixMode(GL_MODELVIEW);
            glLoadMatrixf(camera.loadMatrixf());
            // Test 2
            
             // End Test 2
            
            /* */

            /** **/

            glfwSwapBuffers(window); // swap the color buffers

            // Poll for window events. The key callback above will only be
            // invoked during this call.
            glfwPollEvents();
        }
    }
    
    private void cleanup(){
        // Free the window callbacks and destroy the window
        glfwFreeCallbacks(window);
        glfwDestroyWindow(window);

        // Terminate GLFW and free the error callback
        glfwTerminate();
        glfwSetErrorCallback(null).free();
    }
}
