/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package Bubulle;

import java.nio.FloatBuffer;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.lwjgl.BufferUtils;

public class Camera {
	private Vector3f position;
	private Matrix4f projection;
        private FloatBuffer fb = BufferUtils.createFloatBuffer(16);
	
	public Camera(int width, int height) {
		position = new Vector3f(0,0,0);
		setProjection(width, height);
	}
	
	public void setProjection(int width, int height) {
		projection = new Matrix4f().setOrtho2D(-width/2, width/2, -height/2, height/2);
	}
	
	public void setPosition(Vector3f position) {
		this.position.set(position);
	}

	public void addPosition(Vector3f position) {
		this.position.add(position);
	}
	
	public Vector3f getPosition() { return position; }
	
	public Matrix4f getUntransformedProjection() {
		return projection;
	}
	
	public Matrix4f getProjection() {
		return projection.translate(position, new Matrix4f());
	}
        
        public FloatBuffer loadMatrixf() {
            return projection.get(fb);
        }
}
