/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.text.NumberFormat;
import org.joml.Math;
import org.joml.MemUtil;
import org.joml.Options;
import org.joml.Runtime;
import org.joml.Vector2dc;
import org.joml.Vector2ic;

public class Vector2i
implements Externalizable,
Vector2ic {
    private static final long serialVersionUID = 1L;
    public int x;
    public int y;

    public Vector2i() {
    }

    public Vector2i(int s) {
        this.x = s;
        this.y = s;
    }

    public Vector2i(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Vector2i(Vector2ic v) {
        this.x = v.x();
        this.y = v.y();
    }

    public Vector2i(ByteBuffer buffer) {
        this(buffer.position(), buffer);
    }

    public Vector2i(int index, ByteBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
    }

    public Vector2i(IntBuffer buffer) {
        this(buffer.position(), buffer);
    }

    public Vector2i(int index, IntBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    public Vector2i set(int s) {
        this.x = s;
        this.y = s;
        return this;
    }

    public Vector2i set(int x, int y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public Vector2i set(Vector2ic v) {
        this.x = v.x();
        this.y = v.y();
        return this;
    }

    public Vector2i set(Vector2dc v) {
        this.x = (int)v.x();
        this.y = (int)v.y();
        return this;
    }

    public Vector2i set(ByteBuffer buffer) {
        return this.set(buffer.position(), buffer);
    }

    public Vector2i set(int index, ByteBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
        return this;
    }

    public Vector2i set(IntBuffer buffer) {
        return this.set(buffer.position(), buffer);
    }

    public Vector2i set(int index, IntBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
        return this;
    }

    public Vector2i setComponent(int component, int value) throws IllegalArgumentException {
        switch (component) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this;
    }

    public ByteBuffer get(ByteBuffer buffer) {
        return this.get(buffer.position(), buffer);
    }

    public ByteBuffer get(int index, ByteBuffer buffer) {
        MemUtil.INSTANCE.put(this, index, buffer);
        return buffer;
    }

    public IntBuffer get(IntBuffer buffer) {
        return this.get(buffer.position(), buffer);
    }

    public IntBuffer get(int index, IntBuffer buffer) {
        MemUtil.INSTANCE.put(this, index, buffer);
        return buffer;
    }

    public Vector2i sub(Vector2ic v) {
        this.x -= v.x();
        this.y -= v.y();
        return this;
    }

    public Vector2i sub(Vector2ic v, Vector2i dest) {
        dest.x = this.x - v.x();
        dest.y = this.y - v.y();
        return dest;
    }

    public Vector2i sub(int x, int y) {
        this.x -= x;
        this.y -= y;
        return this;
    }

    public Vector2i sub(int x, int y, Vector2i dest) {
        dest.x = this.x - x;
        dest.y = this.y - y;
        return dest;
    }

    public long lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public double distance(Vector2ic v) {
        return Math.sqrt(this.distanceSquared(v));
    }

    public double distance(int x, int y) {
        return Math.sqrt(this.distanceSquared(x, y));
    }

    public long distanceSquared(Vector2ic v) {
        int dx = this.x - v.x();
        int dy = this.y - v.y();
        return dx * dx + dy * dy;
    }

    public long distanceSquared(int x, int y) {
        int dx = this.x - x;
        int dy = this.y - y;
        return dx * dx + dy * dy;
    }

    public Vector2i add(Vector2ic v) {
        this.x += v.x();
        this.y += v.y();
        return this;
    }

    public Vector2i add(Vector2ic v, Vector2i dest) {
        dest.x = this.x + v.x();
        dest.y = this.y + v.y();
        return dest;
    }

    public Vector2i add(int x, int y) {
        this.x += x;
        this.y += y;
        return this;
    }

    public Vector2i add(int x, int y, Vector2i dest) {
        dest.x = this.x + x;
        dest.y = this.y + y;
        return dest;
    }

    public Vector2i mul(int scalar) {
        this.x *= scalar;
        this.y *= scalar;
        return this;
    }

    public Vector2i mul(int scalar, Vector2i dest) {
        dest.x = this.x * scalar;
        dest.y = this.y * scalar;
        return dest;
    }

    public Vector2i mul(Vector2ic v) {
        this.x += v.x();
        this.y += v.y();
        return this;
    }

    public Vector2i mul(Vector2ic v, Vector2i dest) {
        dest.x = this.x * v.x();
        dest.y = this.y * v.y();
        return dest;
    }

    public Vector2i mul(int x, int y) {
        this.x *= x;
        this.y *= y;
        return this;
    }

    public Vector2i mul(int x, int y, Vector2i dest) {
        dest.x = this.x * x;
        dest.y = this.y * y;
        return dest;
    }

    public Vector2i zero() {
        this.x = 0;
        this.y = 0;
        return this;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.x);
        out.writeInt(this.y);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.x = in.readInt();
        this.y = in.readInt();
    }

    public Vector2i negate() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    public Vector2i negate(Vector2i dest) {
        dest.x = -this.x;
        dest.y = -this.y;
        return dest;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vector2i other = (Vector2i)obj;
        if (this.x != other.x) {
            return false;
        }
        return this.y == other.y;
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat formatter) {
        return "(" + formatter.format(this.x) + " " + formatter.format(this.y) + ")";
    }

    public Vector2ic toImmutable() {
        if (!Options.DEBUG) {
            return this;
        }
        return new Proxy(this);
    }

    private final class Proxy
    implements Vector2ic {
        private final Vector2ic delegate;

        Proxy(Vector2ic delegate) {
            this.delegate = delegate;
        }

        public int x() {
            return this.delegate.x();
        }

        public int y() {
            return this.delegate.y();
        }

        public ByteBuffer get(ByteBuffer buffer) {
            return this.delegate.get(buffer);
        }

        public ByteBuffer get(int index, ByteBuffer buffer) {
            return this.delegate.get(index, buffer);
        }

        public IntBuffer get(IntBuffer buffer) {
            return this.delegate.get(buffer);
        }

        public IntBuffer get(int index, IntBuffer buffer) {
            return this.delegate.get(index, buffer);
        }

        public Vector2i sub(Vector2ic v, Vector2i dest) {
            return this.delegate.sub(v, dest);
        }

        public Vector2i sub(int x, int y, Vector2i dest) {
            return this.delegate.sub(x, y, dest);
        }

        public long lengthSquared() {
            return this.delegate.lengthSquared();
        }

        public double length() {
            return this.delegate.length();
        }

        public double distance(Vector2ic v) {
            return this.delegate.distance(v);
        }

        public double distance(int x, int y) {
            return this.delegate.distance(x, y);
        }

        public long distanceSquared(Vector2ic v) {
            return this.delegate.distanceSquared(v);
        }

        public long distanceSquared(int x, int y) {
            return this.delegate.distanceSquared(x, y);
        }

        public Vector2i add(Vector2ic v, Vector2i dest) {
            return this.delegate.add(v, dest);
        }

        public Vector2i add(int x, int y, Vector2i dest) {
            return this.delegate.add(x, y, dest);
        }

        public Vector2i mul(int scalar, Vector2i dest) {
            return this.delegate.mul(scalar, dest);
        }

        public Vector2i mul(Vector2ic v, Vector2i dest) {
            return this.delegate.mul(v, dest);
        }

        public Vector2i mul(int x, int y, Vector2i dest) {
            return this.delegate.mul(x, y, dest);
        }

        public Vector2i negate(Vector2i dest) {
            return this.delegate.negate(dest);
        }
    }
}

